# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListStorageServers200ResponseAllOfStorageServersInner(BaseModel):
    """
    ListStorageServers200ResponseAllOfStorageServersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    chassis: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    service_url: Optional[StrictStr] = Field(default=None, alias="serviceUrl")
    service_host: Optional[StrictStr] = Field(default=None, alias="serviceHost")
    service_path: Optional[StrictStr] = Field(default=None, alias="servicePath")
    service_token: Optional[StrictStr] = Field(default=None, alias="serviceToken")
    service_token_hash: Optional[StrictStr] = Field(default=None, alias="serviceTokenHash")
    service_version: Optional[StrictStr] = Field(default=None, alias="serviceVersion")
    service_username: Optional[StrictStr] = Field(default=None, alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, alias="servicePassword")
    service_password_hash: Optional[StrictStr] = Field(default=None, alias="servicePasswordHash")
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    api_port: Optional[StrictStr] = Field(default=None, alias="apiPort")
    admin_port: Optional[StrictStr] = Field(default=None, alias="adminPort")
    config: Optional[Dict[str, Any]] = None
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    category: Optional[StrictStr] = None
    server_vendor: Optional[StrictStr] = Field(default=None, alias="serverVendor")
    server_model: Optional[StrictStr] = Field(default=None, alias="serverModel")
    serial_number: Optional[StrictStr] = Field(default=None, alias="serialNumber")
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    max_storage: Optional[StrictStr] = Field(default=None, alias="maxStorage")
    used_storage: Optional[StrictStr] = Field(default=None, alias="usedStorage")
    disk_count: Optional[StrictStr] = Field(default=None, alias="diskCount")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    enabled: Optional[StrictBool] = None
    groups: Optional[List[Dict[str, Any]]] = None
    host_groups: Optional[List[Dict[str, Any]]] = Field(default=None, alias="hostGroups")
    hosts: Optional[List[Dict[str, Any]]] = None
    tenants: Optional[List[Dict[str, Any]]] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    credential: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "type", "chassis", "visibility", "description", "internalId", "externalId", "serviceUrl", "serviceHost", "servicePath", "serviceToken", "serviceTokenHash", "serviceVersion", "serviceUsername", "servicePassword", "servicePasswordHash", "internalIp", "externalIp", "apiPort", "adminPort", "config", "refType", "refId", "category", "serverVendor", "serverModel", "serialNumber", "status", "statusMessage", "statusDate", "errorMessage", "maxStorage", "usedStorage", "diskCount", "dateCreated", "lastUpdated", "enabled", "groups", "hostGroups", "hosts", "tenants", "owner", "credential"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListStorageServers200ResponseAllOfStorageServersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # set to None if chassis (nullable) is None
        # and model_fields_set contains the field
        if self.chassis is None and "chassis" in self.model_fields_set:
            _dict['chassis'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_host (nullable) is None
        # and model_fields_set contains the field
        if self.service_host is None and "service_host" in self.model_fields_set:
            _dict['serviceHost'] = None

        # set to None if service_path (nullable) is None
        # and model_fields_set contains the field
        if self.service_path is None and "service_path" in self.model_fields_set:
            _dict['servicePath'] = None

        # set to None if service_token (nullable) is None
        # and model_fields_set contains the field
        if self.service_token is None and "service_token" in self.model_fields_set:
            _dict['serviceToken'] = None

        # set to None if service_token_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_token_hash is None and "service_token_hash" in self.model_fields_set:
            _dict['serviceTokenHash'] = None

        # set to None if service_version (nullable) is None
        # and model_fields_set contains the field
        if self.service_version is None and "service_version" in self.model_fields_set:
            _dict['serviceVersion'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if service_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_password_hash is None and "service_password_hash" in self.model_fields_set:
            _dict['servicePasswordHash'] = None

        # set to None if internal_ip (nullable) is None
        # and model_fields_set contains the field
        if self.internal_ip is None and "internal_ip" in self.model_fields_set:
            _dict['internalIp'] = None

        # set to None if external_ip (nullable) is None
        # and model_fields_set contains the field
        if self.external_ip is None and "external_ip" in self.model_fields_set:
            _dict['externalIp'] = None

        # set to None if api_port (nullable) is None
        # and model_fields_set contains the field
        if self.api_port is None and "api_port" in self.model_fields_set:
            _dict['apiPort'] = None

        # set to None if admin_port (nullable) is None
        # and model_fields_set contains the field
        if self.admin_port is None and "admin_port" in self.model_fields_set:
            _dict['adminPort'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if server_vendor (nullable) is None
        # and model_fields_set contains the field
        if self.server_vendor is None and "server_vendor" in self.model_fields_set:
            _dict['serverVendor'] = None

        # set to None if server_model (nullable) is None
        # and model_fields_set contains the field
        if self.server_model is None and "server_model" in self.model_fields_set:
            _dict['serverModel'] = None

        # set to None if serial_number (nullable) is None
        # and model_fields_set contains the field
        if self.serial_number is None and "serial_number" in self.model_fields_set:
            _dict['serialNumber'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if max_storage (nullable) is None
        # and model_fields_set contains the field
        if self.max_storage is None and "max_storage" in self.model_fields_set:
            _dict['maxStorage'] = None

        # set to None if used_storage (nullable) is None
        # and model_fields_set contains the field
        if self.used_storage is None and "used_storage" in self.model_fields_set:
            _dict['usedStorage'] = None

        # set to None if disk_count (nullable) is None
        # and model_fields_set contains the field
        if self.disk_count is None and "disk_count" in self.model_fields_set:
            _dict['diskCount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListStorageServers200ResponseAllOfStorageServersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "chassis": obj.get("chassis"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "serviceUrl": obj.get("serviceUrl"),
            "serviceHost": obj.get("serviceHost"),
            "servicePath": obj.get("servicePath"),
            "serviceToken": obj.get("serviceToken"),
            "serviceTokenHash": obj.get("serviceTokenHash"),
            "serviceVersion": obj.get("serviceVersion"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "servicePasswordHash": obj.get("servicePasswordHash"),
            "internalIp": obj.get("internalIp"),
            "externalIp": obj.get("externalIp"),
            "apiPort": obj.get("apiPort"),
            "adminPort": obj.get("adminPort"),
            "config": obj.get("config"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "category": obj.get("category"),
            "serverVendor": obj.get("serverVendor"),
            "serverModel": obj.get("serverModel"),
            "serialNumber": obj.get("serialNumber"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "errorMessage": obj.get("errorMessage"),
            "maxStorage": obj.get("maxStorage"),
            "usedStorage": obj.get("usedStorage"),
            "diskCount": obj.get("diskCount"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "enabled": obj.get("enabled"),
            "groups": obj.get("groups"),
            "hostGroups": obj.get("hostGroups"),
            "hosts": obj.get("hosts"),
            "tenants": obj.get("tenants"),
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "credential": obj.get("credential")
        })
        return _obj


