# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListUserSettings200ResponseAllOfUser(BaseModel):
    """
    ListUserSettings200ResponseAllOfUser
    """ # noqa: E501
    id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    email: Optional[StrictStr] = None
    linux_username: Optional[StrictStr] = Field(default=None, alias="linuxUsername")
    linux_password: Optional[StrictStr] = Field(default=None, alias="linuxPassword")
    linux_key_pair_id: Optional[StrictInt] = Field(default=None, alias="linuxKeyPairId")
    windows_username: Optional[StrictStr] = Field(default=None, alias="windowsUsername")
    windows_password: Optional[StrictStr] = Field(default=None, alias="windowsPassword")
    avatar: Optional[StrictStr] = None
    desktop_background: Optional[StrictStr] = Field(default=None, alias="desktopBackground")
    receive_notifications: Optional[StrictBool] = Field(default=None, alias="receiveNotifications")
    default_group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="defaultGroup")
    default_cloud: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="defaultCloud")
    default_persona: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="defaultPersona")
    is_using2_fa: Optional[StrictBool] = Field(default=None, alias="isUsing2FA")
    tenant: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    __properties: ClassVar[List[str]] = ["id", "username", "firstName", "lastName", "email", "linuxUsername", "linuxPassword", "linuxKeyPairId", "windowsUsername", "windowsPassword", "avatar", "desktopBackground", "receiveNotifications", "defaultGroup", "defaultCloud", "defaultPersona", "isUsing2FA", "tenant"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListUserSettings200ResponseAllOfUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_group
        if self.default_group:
            _dict['defaultGroup'] = self.default_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_cloud
        if self.default_cloud:
            _dict['defaultCloud'] = self.default_cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_persona
        if self.default_persona:
            _dict['defaultPersona'] = self.default_persona.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tenant
        if self.tenant:
            _dict['tenant'] = self.tenant.to_dict()
        # set to None if linux_key_pair_id (nullable) is None
        # and model_fields_set contains the field
        if self.linux_key_pair_id is None and "linux_key_pair_id" in self.model_fields_set:
            _dict['linuxKeyPairId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListUserSettings200ResponseAllOfUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "email": obj.get("email"),
            "linuxUsername": obj.get("linuxUsername"),
            "linuxPassword": obj.get("linuxPassword"),
            "linuxKeyPairId": obj.get("linuxKeyPairId"),
            "windowsUsername": obj.get("windowsUsername"),
            "windowsPassword": obj.get("windowsPassword"),
            "avatar": obj.get("avatar"),
            "desktopBackground": obj.get("desktopBackground"),
            "receiveNotifications": obj.get("receiveNotifications"),
            "defaultGroup": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["defaultGroup"]) if obj.get("defaultGroup") is not None else None,
            "defaultCloud": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["defaultCloud"]) if obj.get("defaultCloud") is not None else None,
            "defaultPersona": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["defaultPersona"]) if obj.get("defaultPersona") is not None else None,
            "isUsing2FA": obj.get("isUsing2FA"),
            "tenant": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["tenant"]) if obj.get("tenant") is not None else None
        })
        return _obj


