# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_vdi_allocations200_response_all_of_vdi_allocations_inner_instance import ListVDIAllocations200ResponseAllOfVdiAllocationsInnerInstance
from morpheus.models.list_vdi_pools200_response_all_of_vdi_pools_inner_owner import ListVDIPools200ResponseAllOfVdiPoolsInnerOwner
from typing import Optional, Set
from typing_extensions import Self

class ListVdi200ResponseAllOfDesktopsInnerAllocation(BaseModel):
    """
    ListVdi200ResponseAllOfDesktopsInnerAllocation
    """ # noqa: E501
    id: Optional[StrictInt] = None
    pool_id: Optional[StrictInt] = Field(default=None, alias="poolId")
    pool: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    instance: Optional[ListVDIAllocations200ResponseAllOfVdiAllocationsInnerInstance] = None
    user: Optional[ListVDIPools200ResponseAllOfVdiPoolsInnerOwner] = None
    local_user_created: Optional[StrictBool] = Field(default=None, alias="localUserCreated")
    persistent: Optional[StrictBool] = None
    recyclable: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_reserved: Optional[datetime] = Field(default=None, alias="lastReserved")
    release_date: Optional[datetime] = Field(default=None, alias="releaseDate")
    __properties: ClassVar[List[str]] = ["id", "poolId", "pool", "instance", "user", "localUserCreated", "persistent", "recyclable", "status", "dateCreated", "lastUpdated", "lastReserved", "releaseDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListVdi200ResponseAllOfDesktopsInnerAllocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict['pool'] = self.pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # set to None if last_reserved (nullable) is None
        # and model_fields_set contains the field
        if self.last_reserved is None and "last_reserved" in self.model_fields_set:
            _dict['lastReserved'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListVdi200ResponseAllOfDesktopsInnerAllocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "poolId": obj.get("poolId"),
            "pool": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["pool"]) if obj.get("pool") is not None else None,
            "instance": ListVDIAllocations200ResponseAllOfVdiAllocationsInnerInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "user": ListVDIPools200ResponseAllOfVdiPoolsInnerOwner.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "localUserCreated": obj.get("localUserCreated"),
            "persistent": obj.get("persistent"),
            "recyclable": obj.get("recyclable"),
            "status": obj.get("status"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastReserved": obj.get("lastReserved"),
            "releaseDate": obj.get("releaseDate")
        })
        return _obj


