# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig(BaseModel):
    """
    ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig
    """ # noqa: E501
    create_user: Optional[StrictBool] = Field(default=None, alias="createUser")
    is_ec2: Optional[StrictBool] = Field(default=None, alias="isEC2")
    is_vpc_selectable: Optional[StrictBool] = Field(default=None, alias="isVpcSelectable")
    no_agent: Optional[StrictBool] = Field(default=None, alias="noAgent")
    smbios_asset_tag: Optional[StrictStr] = Field(default=None, alias="smbiosAssetTag")
    nested_virtualization: Optional[StrictStr] = Field(default=None, alias="nestedVirtualization")
    vmware_folder_id: Optional[StrictStr] = Field(default=None, alias="vmwareFolderId")
    resource_pool_id: Optional[StrictInt] = Field(default=None, alias="resourcePoolId")
    pool_provider_type: Optional[StrictStr] = Field(default=None, alias="poolProviderType")
    __properties: ClassVar[List[str]] = ["createUser", "isEC2", "isVpcSelectable", "noAgent", "smbiosAssetTag", "nestedVirtualization", "vmwareFolderId", "resourcePoolId", "poolProviderType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if smbios_asset_tag (nullable) is None
        # and model_fields_set contains the field
        if self.smbios_asset_tag is None and "smbios_asset_tag" in self.model_fields_set:
            _dict['smbiosAssetTag'] = None

        # set to None if nested_virtualization (nullable) is None
        # and model_fields_set contains the field
        if self.nested_virtualization is None and "nested_virtualization" in self.model_fields_set:
            _dict['nestedVirtualization'] = None

        # set to None if pool_provider_type (nullable) is None
        # and model_fields_set contains the field
        if self.pool_provider_type is None and "pool_provider_type" in self.model_fields_set:
            _dict['poolProviderType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListVDIPools200ResponseAllOfVdiPoolsInnerConfigConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createUser": obj.get("createUser"),
            "isEC2": obj.get("isEC2"),
            "isVpcSelectable": obj.get("isVpcSelectable"),
            "noAgent": obj.get("noAgent"),
            "smbiosAssetTag": obj.get("smbiosAssetTag"),
            "nestedVirtualization": obj.get("nestedVirtualization"),
            "vmwareFolderId": obj.get("vmwareFolderId"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "poolProviderType": obj.get("poolProviderType")
        })
        return _obj


