# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner(BaseModel):
    """
    ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    type_id: Optional[StrictInt] = Field(default=None, alias="typeId")
    type_name: Optional[StrictStr] = Field(default=None, alias="typeName")
    unit_number: Optional[StrictStr] = Field(default=None, alias="unitNumber")
    bus_number: Optional[StrictStr] = Field(default=None, alias="busNumber")
    max_devices: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxDevices")
    removable: Optional[StrictBool] = None
    editable: Optional[StrictBool] = None
    reserved_unit_number: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="reservedUnitNumber")
    category: Optional[StrictStr] = None
    display_order: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="displayOrder")
    __properties: ClassVar[List[str]] = ["id", "name", "active", "typeId", "typeName", "unitNumber", "busNumber", "maxDevices", "removable", "editable", "reservedUnitNumber", "category", "displayOrder"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if active (nullable) is None
        # and model_fields_set contains the field
        if self.active is None and "active" in self.model_fields_set:
            _dict['active'] = None

        # set to None if removable (nullable) is None
        # and model_fields_set contains the field
        if self.removable is None and "removable" in self.model_fields_set:
            _dict['removable'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListVDIPools200ResponseAllOfVdiPoolsInnerConfigStorageControllersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "typeId": obj.get("typeId"),
            "typeName": obj.get("typeName"),
            "unitNumber": obj.get("unitNumber"),
            "busNumber": obj.get("busNumber"),
            "maxDevices": obj.get("maxDevices"),
            "removable": obj.get("removable"),
            "editable": obj.get("editable"),
            "reservedUnitNumber": obj.get("reservedUnitNumber"),
            "category": obj.get("category"),
            "displayOrder": obj.get("displayOrder")
        })
        return _obj


