# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_guidances200_response_all_of_discoveries_inner_any_of_resource_server_os import ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceServerOs
from morpheus.models.list_virtual_images200_response_all_of_virtual_images_inner_config import ListVirtualImages200ResponseAllOfVirtualImagesInnerConfig
from typing import Optional, Set
from typing_extensions import Self

class ListVirtualImages200ResponseAllOfVirtualImagesInner(BaseModel):
    """
    ListVirtualImages200ResponseAllOfVirtualImagesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    owner_id: Optional[StrictInt] = Field(default=None, alias="ownerId")
    tenant: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    image_type: Optional[StrictStr] = Field(default=None, alias="imageType")
    user_uploaded: Optional[StrictBool] = Field(default=None, alias="userUploaded")
    user_defined: Optional[StrictBool] = Field(default=None, alias="userDefined")
    system_image: Optional[StrictBool] = Field(default=None, alias="systemImage")
    is_cloud_init: Optional[StrictBool] = Field(default=None, alias="isCloudInit")
    ssh_username: Optional[StrictStr] = Field(default=None, alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, alias="sshPassword")
    ssh_password_hash: Optional[StrictStr] = Field(default=None, alias="sshPasswordHash")
    ssh_key: Optional[StrictStr] = Field(default=None, alias="sshKey")
    os_type: Optional[ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceServerOs] = Field(default=None, alias="osType")
    min_ram: Optional[StrictInt] = Field(default=None, alias="minRam")
    min_ram_gb: Optional[StrictInt] = Field(default=None, alias="minRamGB")
    min_disk: Optional[StrictStr] = Field(default=None, alias="minDisk")
    min_disk_gb: Optional[StrictStr] = Field(default=None, alias="minDiskGB")
    raw_size: Optional[StrictInt] = Field(default=None, alias="rawSize")
    raw_size_gb: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="rawSizeGB")
    trial_version: Optional[StrictBool] = Field(default=None, alias="trialVersion")
    virtio_supported: Optional[StrictBool] = Field(default=None, alias="virtioSupported")
    uefi: Optional[StrictStr] = None
    is_auto_join_domain: Optional[StrictBool] = Field(default=None, alias="isAutoJoinDomain")
    vm_tools_installed: Optional[StrictBool] = Field(default=None, alias="vmToolsInstalled")
    install_agent: Optional[StrictBool] = Field(default=None, alias="installAgent")
    is_force_customization: Optional[StrictBool] = Field(default=None, alias="isForceCustomization")
    is_sysprep: Optional[StrictBool] = Field(default=None, alias="isSysprep")
    fips_enabled: Optional[StrictBool] = Field(default=None, alias="fipsEnabled")
    user_data: Optional[StrictStr] = Field(default=None, alias="userData")
    console_keymap: Optional[StrictStr] = Field(default=None, alias="consoleKeymap")
    storage_provider: Optional[StrictStr] = Field(default=None, alias="storageProvider")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    visibility: Optional[StrictStr] = None
    accounts: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    config: Optional[ListVirtualImages200ResponseAllOfVirtualImagesInnerConfig] = None
    volumes: Optional[List[Dict[str, Any]]] = None
    storage_controllers: Optional[List[Dict[str, Any]]] = Field(default=None, alias="storageControllers")
    network_interfaces: Optional[List[Dict[str, Any]]] = Field(default=None, alias="networkInterfaces")
    tags: Optional[List[Dict[str, Any]]] = None
    locations: Optional[List[Dict[str, Any]]] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "labels", "ownerId", "tenant", "imageType", "userUploaded", "userDefined", "systemImage", "isCloudInit", "sshUsername", "sshPassword", "sshPasswordHash", "sshKey", "osType", "minRam", "minRamGB", "minDisk", "minDiskGB", "rawSize", "rawSizeGB", "trialVersion", "virtioSupported", "uefi", "isAutoJoinDomain", "vmToolsInstalled", "installAgent", "isForceCustomization", "isSysprep", "fipsEnabled", "userData", "consoleKeymap", "storageProvider", "externalId", "visibility", "accounts", "config", "volumes", "storageControllers", "networkInterfaces", "tags", "locations", "dateCreated", "lastUpdated", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListVirtualImages200ResponseAllOfVirtualImagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tenant
        if self.tenant:
            _dict['tenant'] = self.tenant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of os_type
        if self.os_type:
            _dict['osType'] = self.os_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if ssh_username (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_username is None and "ssh_username" in self.model_fields_set:
            _dict['sshUsername'] = None

        # set to None if ssh_password (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password is None and "ssh_password" in self.model_fields_set:
            _dict['sshPassword'] = None

        # set to None if ssh_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password_hash is None and "ssh_password_hash" in self.model_fields_set:
            _dict['sshPasswordHash'] = None

        # set to None if ssh_key (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_key is None and "ssh_key" in self.model_fields_set:
            _dict['sshKey'] = None

        # set to None if min_ram (nullable) is None
        # and model_fields_set contains the field
        if self.min_ram is None and "min_ram" in self.model_fields_set:
            _dict['minRam'] = None

        # set to None if min_ram_gb (nullable) is None
        # and model_fields_set contains the field
        if self.min_ram_gb is None and "min_ram_gb" in self.model_fields_set:
            _dict['minRamGB'] = None

        # set to None if min_disk (nullable) is None
        # and model_fields_set contains the field
        if self.min_disk is None and "min_disk" in self.model_fields_set:
            _dict['minDisk'] = None

        # set to None if min_disk_gb (nullable) is None
        # and model_fields_set contains the field
        if self.min_disk_gb is None and "min_disk_gb" in self.model_fields_set:
            _dict['minDiskGB'] = None

        # set to None if raw_size (nullable) is None
        # and model_fields_set contains the field
        if self.raw_size is None and "raw_size" in self.model_fields_set:
            _dict['rawSize'] = None

        # set to None if raw_size_gb (nullable) is None
        # and model_fields_set contains the field
        if self.raw_size_gb is None and "raw_size_gb" in self.model_fields_set:
            _dict['rawSizeGB'] = None

        # set to None if uefi (nullable) is None
        # and model_fields_set contains the field
        if self.uefi is None and "uefi" in self.model_fields_set:
            _dict['uefi'] = None

        # set to None if user_data (nullable) is None
        # and model_fields_set contains the field
        if self.user_data is None and "user_data" in self.model_fields_set:
            _dict['userData'] = None

        # set to None if console_keymap (nullable) is None
        # and model_fields_set contains the field
        if self.console_keymap is None and "console_keymap" in self.model_fields_set:
            _dict['consoleKeymap'] = None

        # set to None if storage_provider (nullable) is None
        # and model_fields_set contains the field
        if self.storage_provider is None and "storage_provider" in self.model_fields_set:
            _dict['storageProvider'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListVirtualImages200ResponseAllOfVirtualImagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "ownerId": obj.get("ownerId"),
            "tenant": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["tenant"]) if obj.get("tenant") is not None else None,
            "imageType": obj.get("imageType"),
            "userUploaded": obj.get("userUploaded"),
            "userDefined": obj.get("userDefined"),
            "systemImage": obj.get("systemImage"),
            "isCloudInit": obj.get("isCloudInit"),
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "sshPasswordHash": obj.get("sshPasswordHash"),
            "sshKey": obj.get("sshKey"),
            "osType": ListGuidances200ResponseAllOfDiscoveriesInnerAnyOfResourceServerOs.from_dict(obj["osType"]) if obj.get("osType") is not None else None,
            "minRam": obj.get("minRam"),
            "minRamGB": obj.get("minRamGB"),
            "minDisk": obj.get("minDisk"),
            "minDiskGB": obj.get("minDiskGB"),
            "rawSize": obj.get("rawSize"),
            "rawSizeGB": obj.get("rawSizeGB"),
            "trialVersion": obj.get("trialVersion"),
            "virtioSupported": obj.get("virtioSupported"),
            "uefi": obj.get("uefi"),
            "isAutoJoinDomain": obj.get("isAutoJoinDomain"),
            "vmToolsInstalled": obj.get("vmToolsInstalled"),
            "installAgent": obj.get("installAgent"),
            "isForceCustomization": obj.get("isForceCustomization"),
            "isSysprep": obj.get("isSysprep"),
            "fipsEnabled": obj.get("fipsEnabled"),
            "userData": obj.get("userData"),
            "consoleKeymap": obj.get("consoleKeymap"),
            "storageProvider": obj.get("storageProvider"),
            "externalId": obj.get("externalId"),
            "visibility": obj.get("visibility"),
            "accounts": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["accounts"]] if obj.get("accounts") is not None else None,
            "config": ListVirtualImages200ResponseAllOfVirtualImagesInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "volumes": obj.get("volumes"),
            "storageControllers": obj.get("storageControllers"),
            "networkInterfaces": obj.get("networkInterfaces"),
            "tags": obj.get("tags"),
            "locations": obj.get("locations"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "status": obj.get("status")
        })
        return _obj


