# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_whitelabel_settings200_response_whitelabel_settings_support_menu_links_inner import ListWhitelabelSettings200ResponseWhitelabelSettingsSupportMenuLinksInner
from typing import Optional, Set
from typing_extensions import Self

class ListWhitelabelSettings200ResponseWhitelabelSettings(BaseModel):
    """
    ListWhitelabelSettings200ResponseWhitelabelSettings
    """ # noqa: E501
    enabled: Optional[StrictBool] = None
    appliance_name: Optional[StrictStr] = Field(default=None, alias="applianceName")
    disable_support_menu: Optional[StrictBool] = Field(default=None, alias="disableSupportMenu")
    header_logo: Optional[StrictStr] = Field(default=None, alias="headerLogo")
    footer_logo: Optional[StrictStr] = Field(default=None, alias="footerLogo")
    login_logo: Optional[StrictStr] = Field(default=None, alias="loginLogo")
    favicon: Optional[StrictStr] = None
    header_bg_color: Optional[StrictStr] = Field(default=None, alias="headerBgColor")
    header_fg_color: Optional[StrictStr] = Field(default=None, alias="headerFgColor")
    nav_bg_color: Optional[StrictStr] = Field(default=None, alias="navBgColor")
    nav_fg_color: Optional[StrictStr] = Field(default=None, alias="navFgColor")
    nav_hover_color: Optional[StrictStr] = Field(default=None, alias="navHoverColor")
    primary_button_bg_color: Optional[StrictStr] = Field(default=None, alias="primaryButtonBgColor")
    primary_button_fg_color: Optional[StrictStr] = Field(default=None, alias="primaryButtonFgColor")
    primary_button_hover_bg_color: Optional[StrictStr] = Field(default=None, alias="primaryButtonHoverBgColor")
    primary_button_hover_fg_color: Optional[StrictStr] = Field(default=None, alias="primaryButtonHoverFgColor")
    footer_bg_color: Optional[StrictStr] = Field(default=None, alias="footerBgColor")
    footer_fg_color: Optional[StrictStr] = Field(default=None, alias="footerFgColor")
    login_bg_color: Optional[StrictStr] = Field(default=None, alias="loginBgColor")
    override_css: Optional[StrictStr] = Field(default=None, alias="overrideCss")
    copyright_string: Optional[StrictStr] = Field(default=None, alias="copyrightString")
    terms_of_use: Optional[StrictStr] = Field(default=None, alias="termsOfUse")
    privacy_policy: Optional[StrictStr] = Field(default=None, alias="privacyPolicy")
    support_menu_links: Optional[List[ListWhitelabelSettings200ResponseWhitelabelSettingsSupportMenuLinksInner]] = Field(default=None, alias="supportMenuLinks")
    __properties: ClassVar[List[str]] = ["enabled", "applianceName", "disableSupportMenu", "headerLogo", "footerLogo", "loginLogo", "favicon", "headerBgColor", "headerFgColor", "navBgColor", "navFgColor", "navHoverColor", "primaryButtonBgColor", "primaryButtonFgColor", "primaryButtonHoverBgColor", "primaryButtonHoverFgColor", "footerBgColor", "footerFgColor", "loginBgColor", "overrideCss", "copyrightString", "termsOfUse", "privacyPolicy", "supportMenuLinks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListWhitelabelSettings200ResponseWhitelabelSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in support_menu_links (list)
        _items = []
        if self.support_menu_links:
            for _item_support_menu_links in self.support_menu_links:
                if _item_support_menu_links:
                    _items.append(_item_support_menu_links.to_dict())
            _dict['supportMenuLinks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListWhitelabelSettings200ResponseWhitelabelSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "applianceName": obj.get("applianceName"),
            "disableSupportMenu": obj.get("disableSupportMenu"),
            "headerLogo": obj.get("headerLogo"),
            "footerLogo": obj.get("footerLogo"),
            "loginLogo": obj.get("loginLogo"),
            "favicon": obj.get("favicon"),
            "headerBgColor": obj.get("headerBgColor"),
            "headerFgColor": obj.get("headerFgColor"),
            "navBgColor": obj.get("navBgColor"),
            "navFgColor": obj.get("navFgColor"),
            "navHoverColor": obj.get("navHoverColor"),
            "primaryButtonBgColor": obj.get("primaryButtonBgColor"),
            "primaryButtonFgColor": obj.get("primaryButtonFgColor"),
            "primaryButtonHoverBgColor": obj.get("primaryButtonHoverBgColor"),
            "primaryButtonHoverFgColor": obj.get("primaryButtonHoverFgColor"),
            "footerBgColor": obj.get("footerBgColor"),
            "footerFgColor": obj.get("footerFgColor"),
            "loginBgColor": obj.get("loginBgColor"),
            "overrideCss": obj.get("overrideCss"),
            "copyrightString": obj.get("copyrightString"),
            "termsOfUse": obj.get("termsOfUse"),
            "privacyPolicy": obj.get("privacyPolicy"),
            "supportMenuLinks": [ListWhitelabelSettings200ResponseWhitelabelSettingsSupportMenuLinksInner.from_dict(_item) for _item in obj["supportMenuLinks"]] if obj.get("supportMenuLinks") is not None else None
        })
        return _obj


