# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_workflows200_response_all_of_task_sets_inner_option_types_inner import ListWorkflows200ResponseAllOfTaskSetsInnerOptionTypesInner
from morpheus.models.list_workflows200_response_all_of_task_sets_inner_task_set_tasks_inner import ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInner
from typing import Optional, Set
from typing_extensions import Self

class ListWorkflows200ResponseAllOfTaskSetsInner(BaseModel):
    """
    ListWorkflows200ResponseAllOfTaskSetsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    platform: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    allow_custom_config: Optional[StrictBool] = Field(default=None, alias="allowCustomConfig")
    tasks: Optional[List[StrictInt]] = None
    option_types: Optional[List[ListWorkflows200ResponseAllOfTaskSetsInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    task_set_tasks: Optional[List[ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInner]] = Field(default=None, alias="taskSetTasks")
    __properties: ClassVar[List[str]] = ["id", "name", "type", "description", "labels", "dateCreated", "lastUpdated", "accountId", "platform", "visibility", "allowCustomConfig", "tasks", "optionTypes", "taskSetTasks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListWorkflows200ResponseAllOfTaskSetsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in task_set_tasks (list)
        _items = []
        if self.task_set_tasks:
            for _item_task_set_tasks in self.task_set_tasks:
                if _item_task_set_tasks:
                    _items.append(_item_task_set_tasks.to_dict())
            _dict['taskSetTasks'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if option_types (nullable) is None
        # and model_fields_set contains the field
        if self.option_types is None and "option_types" in self.model_fields_set:
            _dict['optionTypes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListWorkflows200ResponseAllOfTaskSetsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "accountId": obj.get("accountId"),
            "platform": obj.get("platform"),
            "visibility": obj.get("visibility"),
            "allowCustomConfig": obj.get("allowCustomConfig"),
            "tasks": obj.get("tasks"),
            "optionTypes": [ListWorkflows200ResponseAllOfTaskSetsInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "taskSetTasks": [ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInner.from_dict(_item) for _item in obj["taskSetTasks"]] if obj.get("taskSetTasks") is not None else None
        })
        return _obj


