# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from morpheus.models.create_network_dhcp_server_request_network_dhcp_server_config import CreateNetworkDhcpServerRequestNetworkDhcpServerConfig
from typing import Optional, Set
from typing_extensions import Self

class NetworkDhcpServerCreate(BaseModel):
    """
    NetworkDhcpServerCreate
    """ # noqa: E501
    server_ip_address: StrictStr = Field(description="Server Address for the DHCP Server", alias="serverIpAddress")
    lease_time: StrictInt = Field(description="Optional lease time for the DHCP Server", alias="leaseTime")
    name: StrictStr = Field(description="Name")
    config: CreateNetworkDhcpServerRequestNetworkDhcpServerConfig
    __properties: ClassVar[List[str]] = ["serverIpAddress", "leaseTime", "name", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkDhcpServerCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkDhcpServerCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "serverIpAddress": obj.get("serverIpAddress"),
            "leaseTime": obj.get("leaseTime") if obj.get("leaseTime") is not None else 86400,
            "name": obj.get("name"),
            "config": CreateNetworkDhcpServerRequestNetworkDhcpServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        return _obj


