# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class NetworkRouterNat(BaseModel):
    """
    NetworkRouterNat
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    source_network: Optional[StrictStr] = Field(default=None, alias="sourceNetwork")
    destination_network: Optional[StrictStr] = Field(default=None, alias="destinationNetwork")
    translated_network: Optional[StrictStr] = Field(default=None, alias="translatedNetwork")
    source_ports: Optional[StrictStr] = Field(default=None, alias="sourcePorts")
    destination_ports: Optional[StrictStr] = Field(default=None, alias="destinationPorts")
    translated_ports: Optional[StrictStr] = Field(default=None, alias="translatedPorts")
    priority: Optional[StrictInt] = None
    protocol: Optional[StrictStr] = None
    match_ipv6_destination_prefix: Optional[StrictStr] = Field(default=None, alias="matchIpv6DestinationPrefix")
    translated_ipv4_source_prefix: Optional[StrictStr] = Field(default=None, alias="translatedIpv4SourcePrefix")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    sync_source: Optional[StrictStr] = Field(default=None, alias="syncSource")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "enabled", "sourceNetwork", "destinationNetwork", "translatedNetwork", "sourcePorts", "destinationPorts", "translatedPorts", "priority", "protocol", "matchIpv6DestinationPrefix", "translatedIpv4SourcePrefix", "refType", "refId", "syncSource", "internalId", "externalId", "providerId", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkRouterNat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if destination_network (nullable) is None
        # and model_fields_set contains the field
        if self.destination_network is None and "destination_network" in self.model_fields_set:
            _dict['destinationNetwork'] = None

        # set to None if source_ports (nullable) is None
        # and model_fields_set contains the field
        if self.source_ports is None and "source_ports" in self.model_fields_set:
            _dict['sourcePorts'] = None

        # set to None if destination_ports (nullable) is None
        # and model_fields_set contains the field
        if self.destination_ports is None and "destination_ports" in self.model_fields_set:
            _dict['destinationPorts'] = None

        # set to None if translated_ports (nullable) is None
        # and model_fields_set contains the field
        if self.translated_ports is None and "translated_ports" in self.model_fields_set:
            _dict['translatedPorts'] = None

        # set to None if protocol (nullable) is None
        # and model_fields_set contains the field
        if self.protocol is None and "protocol" in self.model_fields_set:
            _dict['protocol'] = None

        # set to None if match_ipv6_destination_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.match_ipv6_destination_prefix is None and "match_ipv6_destination_prefix" in self.model_fields_set:
            _dict['matchIpv6DestinationPrefix'] = None

        # set to None if translated_ipv4_source_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.translated_ipv4_source_prefix is None and "translated_ipv4_source_prefix" in self.model_fields_set:
            _dict['translatedIpv4SourcePrefix'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkRouterNat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "sourceNetwork": obj.get("sourceNetwork"),
            "destinationNetwork": obj.get("destinationNetwork"),
            "translatedNetwork": obj.get("translatedNetwork"),
            "sourcePorts": obj.get("sourcePorts"),
            "destinationPorts": obj.get("destinationPorts"),
            "translatedPorts": obj.get("translatedPorts"),
            "priority": obj.get("priority"),
            "protocol": obj.get("protocol"),
            "matchIpv6DestinationPrefix": obj.get("matchIpv6DestinationPrefix"),
            "translatedIpv4SourcePrefix": obj.get("translatedIpv4SourcePrefix"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "syncSource": obj.get("syncSource"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "providerId": obj.get("providerId"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


