# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class NetworkRouterRoute(BaseModel):
    """
    NetworkRouterRoute
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    priority: Optional[StrictStr] = None
    route_type: Optional[StrictStr] = Field(default=None, alias="routeType")
    source: Optional[StrictStr] = None
    source_type: Optional[StrictStr] = Field(default=None, alias="sourceType")
    destination: Optional[StrictStr] = None
    destination_type: Optional[StrictStr] = Field(default=None, alias="destinationType")
    default_route: Optional[StrictBool] = Field(default=None, alias="defaultRoute")
    network_mtu: Optional[StrictStr] = Field(default=None, alias="networkMtu")
    external_interface: Optional[StrictStr] = Field(default=None, alias="externalInterface")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    external_type: Optional[StrictStr] = Field(default=None, alias="externalType")
    enabled: Optional[StrictBool] = None
    visible: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "name", "code", "description", "priority", "routeType", "source", "sourceType", "destination", "destinationType", "defaultRoute", "networkMtu", "externalInterface", "internalId", "externalId", "uniqueId", "providerId", "externalType", "enabled", "visible"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkRouterRoute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if priority (nullable) is None
        # and model_fields_set contains the field
        if self.priority is None and "priority" in self.model_fields_set:
            _dict['priority'] = None

        # set to None if network_mtu (nullable) is None
        # and model_fields_set contains the field
        if self.network_mtu is None and "network_mtu" in self.model_fields_set:
            _dict['networkMtu'] = None

        # set to None if external_interface (nullable) is None
        # and model_fields_set contains the field
        if self.external_interface is None and "external_interface" in self.model_fields_set:
            _dict['externalInterface'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['uniqueId'] = None

        # set to None if external_type (nullable) is None
        # and model_fields_set contains the field
        if self.external_type is None and "external_type" in self.model_fields_set:
            _dict['externalType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkRouterRoute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "priority": obj.get("priority"),
            "routeType": obj.get("routeType"),
            "source": obj.get("source"),
            "sourceType": obj.get("sourceType"),
            "destination": obj.get("destination"),
            "destinationType": obj.get("destinationType"),
            "defaultRoute": obj.get("defaultRoute"),
            "networkMtu": obj.get("networkMtu"),
            "externalInterface": obj.get("externalInterface"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "uniqueId": obj.get("uniqueId"),
            "providerId": obj.get("providerId"),
            "externalType": obj.get("externalType"),
            "enabled": obj.get("enabled"),
            "visible": obj.get("visible")
        })
        return _obj


