# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_network_server_groups200_response_all_of_groups_inner_members_inner import ListNetworkServerGroups200ResponseAllOfGroupsInnerMembersInner
from morpheus.models.list_network_server_groups200_response_all_of_groups_inner_permissions import ListNetworkServerGroups200ResponseAllOfGroupsInnerPermissions
from morpheus.models.list_network_server_groups200_response_all_of_groups_inner_tags_inner import ListNetworkServerGroups200ResponseAllOfGroupsInnerTagsInner
from typing import Optional, Set
from typing_extensions import Self

class NetworkServerGroupCreate(BaseModel):
    """
    NetworkServerGroupCreate
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: StrictStr
    description: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    visibility: Optional[StrictStr] = None
    account: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    owner: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    network_server: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(default=None, alias="networkServer")
    permissions: Optional[ListNetworkServerGroups200ResponseAllOfGroupsInnerPermissions] = None
    tags: Optional[List[ListNetworkServerGroups200ResponseAllOfGroupsInnerTagsInner]] = None
    members: Optional[List[ListNetworkServerGroups200ResponseAllOfGroupsInnerMembersInner]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "internalId", "externalId", "visibility", "account", "owner", "networkServer", "permissions", "tags", "members"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkServerGroupCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item_members in self.members:
                if _item_members:
                    _items.append(_item_members.to_dict())
            _dict['members'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkServerGroupCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "visibility": obj.get("visibility"),
            "account": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "owner": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "networkServer": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "permissions": ListNetworkServerGroups200ResponseAllOfGroupsInnerPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "tags": [ListNetworkServerGroups200ResponseAllOfGroupsInnerTagsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "members": [ListNetworkServerGroups200ResponseAllOfGroupsInnerMembersInner.from_dict(_item) for _item in obj["members"]] if obj.get("members") is not None else None
        })
        return _obj


