# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.nsx_network_server_config import NSXNetworkServerConfig
from morpheus.models.nsx_network_server_credential import NSXNetworkServerCredential
from typing import Optional, Set
from typing_extensions import Self

class NSXNetworkServer(BaseModel):
    """
    NSXNetworkServer
    """ # noqa: E501
    type: StrictStr = Field(description="Type Code (nsx-t)")
    name: StrictStr = Field(description="Name")
    enabled: Optional[StrictBool] = Field(default=True, description="Can be used to enable / disable the network server.")
    service_url: Optional[StrictStr] = Field(description="URL", alias="serviceUrl")
    service_username: Optional[StrictStr] = Field(default=None, description="Username", alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, description="Password", alias="servicePassword")
    config: Optional[NSXNetworkServerConfig] = None
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility - Set to public to allow all tenants")
    zone_id: StrictInt = Field(description="ID of the Cloud that the NSX network server integration should be attached to.", alias="zoneId")
    credential: Optional[NSXNetworkServerCredential] = None
    tenants: Optional[List[GetAlerts200ResponseAllOfChecksInnerAccount]] = Field(default=None, description="Array of tenant account ids that are allowed access")
    __properties: ClassVar[List[str]] = ["type", "name", "enabled", "serviceUrl", "serviceUsername", "servicePassword", "config", "visibility", "zoneId", "credential", "tenants"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['nsx-t']):
            raise ValueError("must be one of enum values ('nsx-t')")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private']):
            raise ValueError("must be one of enum values ('public', 'private')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NSXNetworkServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NSXNetworkServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "serviceUrl": obj.get("serviceUrl"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "config": NSXNetworkServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "zoneId": obj.get("zoneId"),
            "credential": NSXNetworkServerCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "tenants": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None
        })
        return _obj


