# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_option_forms200_response_all_of_option_types_inner_field_groups_inner import ListOptionForms200ResponseAllOfOptionTypesInnerFieldGroupsInner
from morpheus.models.list_option_forms200_response_all_of_option_types_inner_options_inner import ListOptionForms200ResponseAllOfOptionTypesInnerOptionsInner
from typing import Optional, Set
from typing_extensions import Self

class OptionTypeFormUpdate(BaseModel):
    """
    OptionTypeFormUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Form name")
    code: Optional[StrictStr] = Field(default=None, description="Unique form code")
    description: Optional[StrictStr] = Field(default=None, description="A short description of the form")
    labels: Optional[List[StrictStr]] = None
    options: Optional[List[ListOptionForms200ResponseAllOfOptionTypesInnerOptionsInner]] = Field(default=None, description="Inputs")
    field_groups: Optional[List[ListOptionForms200ResponseAllOfOptionTypesInnerFieldGroupsInner]] = Field(default=None, description="Field Groups", alias="fieldGroups")
    __properties: ClassVar[List[str]] = ["name", "code", "description", "labels", "options", "fieldGroups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OptionTypeFormUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item_options in self.options:
                if _item_options:
                    _items.append(_item_options.to_dict())
            _dict['options'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in field_groups (list)
        _items = []
        if self.field_groups:
            for _item_field_groups in self.field_groups:
                if _item_field_groups:
                    _items.append(_item_field_groups.to_dict())
            _dict['fieldGroups'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OptionTypeFormUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "options": [ListOptionForms200ResponseAllOfOptionTypesInnerOptionsInner.from_dict(_item) for _item in obj["options"]] if obj.get("options") is not None else None,
            "fieldGroups": [ListOptionForms200ResponseAllOfOptionTypesInnerFieldGroupsInner.from_dict(_item) for _item in obj["fieldGroups"]] if obj.get("fieldGroups") is not None else None
        })
        return _obj


