# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OsTypeImage(BaseModel):
    """
    OsTypeImage
    """ # noqa: E501
    id: Optional[StrictInt] = None
    virtual_image_id: Optional[StrictInt] = Field(default=None, description="The id of the virtual image. ", alias="virtualImageId")
    virtual_image_name: Optional[StrictStr] = Field(default=None, description="The name of the virtual image.  ", alias="virtualImageName")
    account: Optional[StrictInt] = Field(default=None, description="The account attached to the osTypeImage.  ")
    provision_type: Optional[StrictInt] = Field(default=None, description="The Provision Type of the osTypeImage. ", alias="provisionType")
    compute_zone_type: Optional[StrictInt] = Field(default=None, description="The zone type of the osTypeImage. ", alias="computeZoneType")
    zone: Optional[StrictInt] = Field(default=None, description="The cloud that is attached to osTypeImage.")
    __properties: ClassVar[List[str]] = ["id", "virtualImageId", "virtualImageName", "account", "provisionType", "computeZoneType", "zone"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OsTypeImage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if account (nullable) is None
        # and model_fields_set contains the field
        if self.account is None and "account" in self.model_fields_set:
            _dict['account'] = None

        # set to None if provision_type (nullable) is None
        # and model_fields_set contains the field
        if self.provision_type is None and "provision_type" in self.model_fields_set:
            _dict['provisionType'] = None

        # set to None if compute_zone_type (nullable) is None
        # and model_fields_set contains the field
        if self.compute_zone_type is None and "compute_zone_type" in self.model_fields_set:
            _dict['computeZoneType'] = None

        # set to None if zone (nullable) is None
        # and model_fields_set contains the field
        if self.zone is None and "zone" in self.model_fields_set:
            _dict['zone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OsTypeImage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "virtualImageId": obj.get("virtualImageId"),
            "virtualImageName": obj.get("virtualImageName"),
            "account": obj.get("account"),
            "provisionType": obj.get("provisionType"),
            "computeZoneType": obj.get("computeZoneType"),
            "zone": obj.get("zone")
        })
        return _obj


