# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.prepare_app_apply200_response_all_of_data_terraform import PrepareAppApply200ResponseAllOfDataTerraform
from typing import Optional, Set
from typing_extensions import Self

class PrepareAppApply200ResponseAllOfData(BaseModel):
    """
    PrepareAppApply200ResponseAllOfData
    """ # noqa: E501
    image: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    auto_validate: Optional[StrictBool] = Field(default=None, alias="autoValidate")
    terraform: Optional[PrepareAppApply200ResponseAllOfDataTerraform] = None
    type: Optional[StrictStr] = None
    config: Optional[Dict[str, Any]] = None
    blueprint_name: Optional[StrictStr] = Field(default=None, alias="blueprintName")
    description: Optional[StrictStr] = None
    template_id: Optional[StrictInt] = Field(default=None, alias="templateId")
    blueprint_id: Optional[StrictInt] = Field(default=None, alias="blueprintId")
    group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    __properties: ClassVar[List[str]] = ["image", "name", "autoValidate", "terraform", "type", "config", "blueprintName", "description", "templateId", "blueprintId", "group"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrepareAppApply200ResponseAllOfData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of terraform
        if self.terraform:
            _dict['terraform'] = self.terraform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrepareAppApply200ResponseAllOfData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "image": obj.get("image"),
            "name": obj.get("name"),
            "autoValidate": obj.get("autoValidate"),
            "terraform": PrepareAppApply200ResponseAllOfDataTerraform.from_dict(obj["terraform"]) if obj.get("terraform") is not None else None,
            "type": obj.get("type"),
            "config": obj.get("config"),
            "blueprintName": obj.get("blueprintName"),
            "description": obj.get("description"),
            "templateId": obj.get("templateId"),
            "blueprintId": obj.get("blueprintId"),
            "group": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["group"]) if obj.get("group") is not None else None
        })
        return _obj


