# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_provision_type_controller_types_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeControllerTypesInner
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_provision_type_network_types_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeNetworkTypesInner
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_provision_type_storage_types_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ProvisionType(BaseModel):
    """
    ProvisionType
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    acl_enabled: Optional[StrictBool] = Field(default=None, alias="aclEnabled")
    multi_tenant: Optional[StrictBool] = Field(default=None, alias="multiTenant")
    managed: Optional[StrictBool] = None
    host_network: Optional[StrictBool] = Field(default=None, alias="hostNetwork")
    custom_supported: Optional[StrictBool] = Field(default=None, alias="customSupported")
    map_ports: Optional[StrictBool] = Field(default=None, alias="mapPorts")
    export_server: Optional[StrictBool] = Field(default=None, alias="exportServer")
    view_set: Optional[StrictStr] = Field(default=None, alias="viewSet")
    server_type: Optional[StrictStr] = Field(default=None, alias="serverType")
    host_type: Optional[StrictStr] = Field(default=None, alias="hostType")
    add_volumes: Optional[StrictBool] = Field(default=None, alias="addVolumes")
    has_volumes: Optional[StrictBool] = Field(default=None, alias="hasVolumes")
    has_datastore: Optional[StrictBool] = Field(default=None, alias="hasDatastore")
    has_networks: Optional[StrictBool] = Field(default=None, alias="hasNetworks")
    max_networks: Optional[StrictInt] = Field(default=None, alias="maxNetworks")
    customize_volume: Optional[StrictBool] = Field(default=None, alias="customizeVolume")
    root_disk_customizable: Optional[StrictBool] = Field(default=None, alias="rootDiskCustomizable")
    root_disk_size_known: Optional[StrictBool] = Field(default=None, alias="rootDiskSizeKnown")
    root_disk_resizable: Optional[StrictBool] = Field(default=None, alias="rootDiskResizable")
    lvm_supported: Optional[StrictBool] = Field(default=None, alias="lvmSupported")
    host_disk_mode: Optional[StrictStr] = Field(default=None, alias="hostDiskMode")
    min_disk: Optional[StrictInt] = Field(default=None, alias="minDisk")
    max_disk: Optional[StrictStr] = Field(default=None, alias="maxDisk")
    resize_copies_volumes: Optional[StrictBool] = Field(default=None, alias="resizeCopiesVolumes")
    supports_auto_datastore: Optional[StrictBool] = Field(default=None, alias="supportsAutoDatastore")
    has_zone_pools: Optional[StrictBool] = Field(default=None, alias="hasZonePools")
    has_security_groups: Optional[StrictBool] = Field(default=None, alias="hasSecurityGroups")
    has_parameters: Optional[StrictBool] = Field(default=None, alias="hasParameters")
    can_enforce_tags: Optional[StrictBool] = Field(default=None, alias="canEnforceTags")
    disable_root_datastore: Optional[StrictBool] = Field(default=None, alias="disableRootDatastore")
    has_snapshots: Optional[StrictBool] = Field(default=None, alias="hasSnapshots")
    has_memory_snapshots: Optional[StrictBool] = Field(default=None, alias="hasMemorySnapshots")
    has_spec_templates: Optional[StrictBool] = Field(default=None, alias="hasSpecTemplates")
    has_preview: Optional[StrictBool] = Field(default=None, alias="hasPreview")
    zone_pool_required: Optional[StrictBool] = Field(default=None, alias="zonePoolRequired")
    plan_requires_pool: Optional[StrictBool] = Field(default=None, alias="planRequiresPool")
    has_folders: Optional[StrictBool] = Field(default=None, alias="hasFolders")
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    custom_option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="customOptionTypes")
    network_types: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeNetworkTypesInner]] = Field(default=None, alias="networkTypes")
    storage_types: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner]] = Field(default=None, alias="storageTypes")
    root_storage_types: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner]] = Field(default=None, alias="rootStorageTypes")
    controller_types: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeControllerTypesInner]] = Field(default=None, alias="controllerTypes")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "code", "aclEnabled", "multiTenant", "managed", "hostNetwork", "customSupported", "mapPorts", "exportServer", "viewSet", "serverType", "hostType", "addVolumes", "hasVolumes", "hasDatastore", "hasNetworks", "maxNetworks", "customizeVolume", "rootDiskCustomizable", "rootDiskSizeKnown", "rootDiskResizable", "lvmSupported", "hostDiskMode", "minDisk", "maxDisk", "resizeCopiesVolumes", "supportsAutoDatastore", "hasZonePools", "hasSecurityGroups", "hasParameters", "canEnforceTags", "disableRootDatastore", "hasSnapshots", "hasMemorySnapshots", "hasSpecTemplates", "hasPreview", "zonePoolRequired", "planRequiresPool", "hasFolders", "optionTypes", "customOptionTypes", "networkTypes", "storageTypes", "rootStorageTypes", "controllerTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProvisionType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_option_types (list)
        _items = []
        if self.custom_option_types:
            for _item_custom_option_types in self.custom_option_types:
                if _item_custom_option_types:
                    _items.append(_item_custom_option_types.to_dict())
            _dict['customOptionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_types (list)
        _items = []
        if self.network_types:
            for _item_network_types in self.network_types:
                if _item_network_types:
                    _items.append(_item_network_types.to_dict())
            _dict['networkTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in storage_types (list)
        _items = []
        if self.storage_types:
            for _item_storage_types in self.storage_types:
                if _item_storage_types:
                    _items.append(_item_storage_types.to_dict())
            _dict['storageTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in root_storage_types (list)
        _items = []
        if self.root_storage_types:
            for _item_root_storage_types in self.root_storage_types:
                if _item_root_storage_types:
                    _items.append(_item_root_storage_types.to_dict())
            _dict['rootStorageTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in controller_types (list)
        _items = []
        if self.controller_types:
            for _item_controller_types in self.controller_types:
                if _item_controller_types:
                    _items.append(_item_controller_types.to_dict())
            _dict['controllerTypes'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if view_set (nullable) is None
        # and model_fields_set contains the field
        if self.view_set is None and "view_set" in self.model_fields_set:
            _dict['viewSet'] = None

        # set to None if max_disk (nullable) is None
        # and model_fields_set contains the field
        if self.max_disk is None and "max_disk" in self.model_fields_set:
            _dict['maxDisk'] = None

        # set to None if can_enforce_tags (nullable) is None
        # and model_fields_set contains the field
        if self.can_enforce_tags is None and "can_enforce_tags" in self.model_fields_set:
            _dict['canEnforceTags'] = None

        # set to None if has_folders (nullable) is None
        # and model_fields_set contains the field
        if self.has_folders is None and "has_folders" in self.model_fields_set:
            _dict['hasFolders'] = None

        # set to None if option_types (nullable) is None
        # and model_fields_set contains the field
        if self.option_types is None and "option_types" in self.model_fields_set:
            _dict['optionTypes'] = None

        # set to None if custom_option_types (nullable) is None
        # and model_fields_set contains the field
        if self.custom_option_types is None and "custom_option_types" in self.model_fields_set:
            _dict['customOptionTypes'] = None

        # set to None if network_types (nullable) is None
        # and model_fields_set contains the field
        if self.network_types is None and "network_types" in self.model_fields_set:
            _dict['networkTypes'] = None

        # set to None if storage_types (nullable) is None
        # and model_fields_set contains the field
        if self.storage_types is None and "storage_types" in self.model_fields_set:
            _dict['storageTypes'] = None

        # set to None if root_storage_types (nullable) is None
        # and model_fields_set contains the field
        if self.root_storage_types is None and "root_storage_types" in self.model_fields_set:
            _dict['rootStorageTypes'] = None

        # set to None if controller_types (nullable) is None
        # and model_fields_set contains the field
        if self.controller_types is None and "controller_types" in self.model_fields_set:
            _dict['controllerTypes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProvisionType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "code": obj.get("code"),
            "aclEnabled": obj.get("aclEnabled"),
            "multiTenant": obj.get("multiTenant"),
            "managed": obj.get("managed"),
            "hostNetwork": obj.get("hostNetwork"),
            "customSupported": obj.get("customSupported"),
            "mapPorts": obj.get("mapPorts"),
            "exportServer": obj.get("exportServer"),
            "viewSet": obj.get("viewSet"),
            "serverType": obj.get("serverType"),
            "hostType": obj.get("hostType"),
            "addVolumes": obj.get("addVolumes"),
            "hasVolumes": obj.get("hasVolumes"),
            "hasDatastore": obj.get("hasDatastore"),
            "hasNetworks": obj.get("hasNetworks"),
            "maxNetworks": obj.get("maxNetworks"),
            "customizeVolume": obj.get("customizeVolume"),
            "rootDiskCustomizable": obj.get("rootDiskCustomizable"),
            "rootDiskSizeKnown": obj.get("rootDiskSizeKnown"),
            "rootDiskResizable": obj.get("rootDiskResizable"),
            "lvmSupported": obj.get("lvmSupported"),
            "hostDiskMode": obj.get("hostDiskMode"),
            "minDisk": obj.get("minDisk"),
            "maxDisk": obj.get("maxDisk"),
            "resizeCopiesVolumes": obj.get("resizeCopiesVolumes"),
            "supportsAutoDatastore": obj.get("supportsAutoDatastore"),
            "hasZonePools": obj.get("hasZonePools"),
            "hasSecurityGroups": obj.get("hasSecurityGroups"),
            "hasParameters": obj.get("hasParameters"),
            "canEnforceTags": obj.get("canEnforceTags"),
            "disableRootDatastore": obj.get("disableRootDatastore"),
            "hasSnapshots": obj.get("hasSnapshots"),
            "hasMemorySnapshots": obj.get("hasMemorySnapshots"),
            "hasSpecTemplates": obj.get("hasSpecTemplates"),
            "hasPreview": obj.get("hasPreview"),
            "zonePoolRequired": obj.get("zonePoolRequired"),
            "planRequiresPool": obj.get("planRequiresPool"),
            "hasFolders": obj.get("hasFolders"),
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "customOptionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["customOptionTypes"]] if obj.get("customOptionTypes") is not None else None,
            "networkTypes": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeNetworkTypesInner.from_dict(_item) for _item in obj["networkTypes"]] if obj.get("networkTypes") is not None else None,
            "storageTypes": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner.from_dict(_item) for _item in obj["storageTypes"]] if obj.get("storageTypes") is not None else None,
            "rootStorageTypes": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeStorageTypesInner.from_dict(_item) for _item in obj["rootStorageTypes"]] if obj.get("rootStorageTypes") is not None else None,
            "controllerTypes": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerProvisionTypeControllerTypesInner.from_dict(_item) for _item in obj["controllerTypes"]] if obj.get("controllerTypes") is not None else None
        })
        return _obj


