# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_provisioning_settings_request_provisioning_settings_cloud_init_key_pair import UpdateProvisioningSettingsRequestProvisioningSettingsCloudInitKeyPair
from morpheus.models.update_provisioning_settings_request_provisioning_settings_default_template_type import UpdateProvisioningSettingsRequestProvisioningSettingsDefaultTemplateType
from morpheus.models.update_provisioning_settings_request_provisioning_settings_deploy_storage_provider import UpdateProvisioningSettingsRequestProvisioningSettingsDeployStorageProvider
from typing import Optional, Set
from typing_extensions import Self

class ProvisioningSettingsUpdate(BaseModel):
    """
    ProvisioningSettingsUpdate
    """ # noqa: E501
    allow_zone_selection: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable allowing cloud selection", alias="allowZoneSelection")
    allow_server_selection: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable allowing host selection", alias="allowServerSelection")
    require_environments: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable requiring environment selection", alias="requireEnvironments")
    show_pricing: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable showing pricing", alias="showPricing")
    hide_datastore_stats: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable hiding datastore stats", alias="hideDatastoreStats")
    cross_tenant_naming_policies: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable cross-tenant naming policies", alias="crossTenantNamingPolicies")
    reuse_sequence: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable reusing naming sequence numbers", alias="reuseSequence")
    cloud_init_username: Optional[StrictStr] = Field(default=None, description="Cloud-init username", alias="cloudInitUsername")
    cloud_init_password: Optional[StrictStr] = Field(default=None, description="Cloud-init password", alias="cloudInitPassword")
    cloud_init_key_pair: Optional[UpdateProvisioningSettingsRequestProvisioningSettingsCloudInitKeyPair] = Field(default=None, alias="cloudInitKeyPair")
    deploy_storage_provider: Optional[UpdateProvisioningSettingsRequestProvisioningSettingsDeployStorageProvider] = Field(default=None, alias="deployStorageProvider")
    windows_password: Optional[StrictStr] = Field(default=None, description="Windows administrator password", alias="windowsPassword")
    pxe_root_password: Optional[StrictStr] = Field(default=None, description="PXE Boot default root password", alias="pxeRootPassword")
    default_template_type: Optional[UpdateProvisioningSettingsRequestProvisioningSettingsDefaultTemplateType] = Field(default=None, alias="defaultTemplateType")
    __properties: ClassVar[List[str]] = ["allowZoneSelection", "allowServerSelection", "requireEnvironments", "showPricing", "hideDatastoreStats", "crossTenantNamingPolicies", "reuseSequence", "cloudInitUsername", "cloudInitPassword", "cloudInitKeyPair", "deployStorageProvider", "windowsPassword", "pxeRootPassword", "defaultTemplateType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProvisioningSettingsUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud_init_key_pair
        if self.cloud_init_key_pair:
            _dict['cloudInitKeyPair'] = self.cloud_init_key_pair.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deploy_storage_provider
        if self.deploy_storage_provider:
            _dict['deployStorageProvider'] = self.deploy_storage_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_template_type
        if self.default_template_type:
            _dict['defaultTemplateType'] = self.default_template_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProvisioningSettingsUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowZoneSelection": obj.get("allowZoneSelection"),
            "allowServerSelection": obj.get("allowServerSelection"),
            "requireEnvironments": obj.get("requireEnvironments"),
            "showPricing": obj.get("showPricing"),
            "hideDatastoreStats": obj.get("hideDatastoreStats"),
            "crossTenantNamingPolicies": obj.get("crossTenantNamingPolicies"),
            "reuseSequence": obj.get("reuseSequence"),
            "cloudInitUsername": obj.get("cloudInitUsername"),
            "cloudInitPassword": obj.get("cloudInitPassword"),
            "cloudInitKeyPair": UpdateProvisioningSettingsRequestProvisioningSettingsCloudInitKeyPair.from_dict(obj["cloudInitKeyPair"]) if obj.get("cloudInitKeyPair") is not None else None,
            "deployStorageProvider": UpdateProvisioningSettingsRequestProvisioningSettingsDeployStorageProvider.from_dict(obj["deployStorageProvider"]) if obj.get("deployStorageProvider") is not None else None,
            "windowsPassword": obj.get("windowsPassword"),
            "pxeRootPassword": obj.get("pxeRootPassword"),
            "defaultTemplateType": UpdateProvisioningSettingsRequestProvisioningSettingsDefaultTemplateType.from_dict(obj["defaultTemplateType"]) if obj.get("defaultTemplateType") is not None else None
        })
        return _obj


