# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ScriptCreate(BaseModel):
    """
    ScriptCreate
    """ # noqa: E501
    name: StrictStr = Field(description="Script name")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    category: Optional[StrictStr] = Field(default=None, description="Script category")
    script_version: Optional[StrictStr] = Field(default='1', description="Version of the script", alias="scriptVersion")
    script_phase: Optional[StrictStr] = Field(default=None, description="Phase for the script, provision, start, etc.", alias="scriptPhase")
    script_type: Optional[StrictStr] = Field(default='bash', description="Type for the script", alias="scriptType")
    script: Optional[StrictStr] = Field(default=None, description="Script content, that is, the code itself.")
    run_as_user: Optional[StrictStr] = Field(default=None, description="Run as a specific user.", alias="runAsUser")
    sudo_user: Optional[StrictBool] = Field(default=False, description="Sudo, whether or not to run with sudo.", alias="sudoUser")
    __properties: ClassVar[List[str]] = ["name", "labels", "category", "scriptVersion", "scriptPhase", "scriptType", "script", "runAsUser", "sudoUser"]

    @field_validator('script_type')
    def script_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['bash', 'powershell']):
            raise ValueError("must be one of enum values ('bash', 'powershell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScriptCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScriptCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "category": obj.get("category"),
            "scriptVersion": obj.get("scriptVersion") if obj.get("scriptVersion") is not None else '1',
            "scriptPhase": obj.get("scriptPhase"),
            "scriptType": obj.get("scriptType") if obj.get("scriptType") is not None else 'bash',
            "script": obj.get("script"),
            "runAsUser": obj.get("runAsUser"),
            "sudoUser": obj.get("sudoUser") if obj.get("sudoUser") is not None else False
        })
        return _obj


