# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class SecurityGroupRule(BaseModel):
    """
    SecurityGroupRule
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    rule_type: Optional[StrictStr] = Field(default=None, alias="ruleType")
    custom_rule: Optional[StrictBool] = Field(default=None, alias="customRule")
    instance_type_id: Optional[StrictStr] = Field(default=None, alias="instanceTypeId")
    direction: Optional[StrictStr] = None
    policy: Optional[StrictStr] = None
    source_type: Optional[StrictStr] = Field(default=None, alias="sourceType")
    source: Optional[StrictStr] = None
    source_group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="sourceGroup")
    source_tier: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="sourceTier")
    port_range: Optional[StrictStr] = Field(default=None, alias="portRange")
    source_port_range: Optional[StrictStr] = Field(default=None, alias="sourcePortRange")
    destination_port_range: Optional[StrictStr] = Field(default=None, alias="destinationPortRange")
    protocol: Optional[StrictStr] = None
    destination_type: Optional[StrictStr] = Field(default=None, alias="destinationType")
    destination: Optional[StrictStr] = None
    destination_group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="destinationGroup")
    destination_tier: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="destinationTier")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    enabled: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "ruleType", "customRule", "instanceTypeId", "direction", "policy", "sourceType", "source", "sourceGroup", "sourceTier", "portRange", "sourcePortRange", "destinationPortRange", "protocol", "destinationType", "destination", "destinationGroup", "destinationTier", "externalId", "enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecurityGroupRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_group
        if self.source_group:
            _dict['sourceGroup'] = self.source_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_tier
        if self.source_tier:
            _dict['sourceTier'] = self.source_tier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination_group
        if self.destination_group:
            _dict['destinationGroup'] = self.destination_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination_tier
        if self.destination_tier:
            _dict['destinationTier'] = self.destination_tier.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if instance_type_id (nullable) is None
        # and model_fields_set contains the field
        if self.instance_type_id is None and "instance_type_id" in self.model_fields_set:
            _dict['instanceTypeId'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if port_range (nullable) is None
        # and model_fields_set contains the field
        if self.port_range is None and "port_range" in self.model_fields_set:
            _dict['portRange'] = None

        # set to None if source_port_range (nullable) is None
        # and model_fields_set contains the field
        if self.source_port_range is None and "source_port_range" in self.model_fields_set:
            _dict['sourcePortRange'] = None

        # set to None if destination_port_range (nullable) is None
        # and model_fields_set contains the field
        if self.destination_port_range is None and "destination_port_range" in self.model_fields_set:
            _dict['destinationPortRange'] = None

        # set to None if destination (nullable) is None
        # and model_fields_set contains the field
        if self.destination is None and "destination" in self.model_fields_set:
            _dict['destination'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict['enabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecurityGroupRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "ruleType": obj.get("ruleType"),
            "customRule": obj.get("customRule"),
            "instanceTypeId": obj.get("instanceTypeId"),
            "direction": obj.get("direction"),
            "policy": obj.get("policy"),
            "sourceType": obj.get("sourceType"),
            "source": obj.get("source"),
            "sourceGroup": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["sourceGroup"]) if obj.get("sourceGroup") is not None else None,
            "sourceTier": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["sourceTier"]) if obj.get("sourceTier") is not None else None,
            "portRange": obj.get("portRange"),
            "sourcePortRange": obj.get("sourcePortRange"),
            "destinationPortRange": obj.get("destinationPortRange"),
            "protocol": obj.get("protocol"),
            "destinationType": obj.get("destinationType"),
            "destination": obj.get("destination"),
            "destinationGroup": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["destinationGroup"]) if obj.get("destinationGroup") is not None else None,
            "destinationTier": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["destinationTier"]) if obj.get("destinationTier") is not None else None,
            "externalId": obj.get("externalId"),
            "enabled": obj.get("enabled")
        })
        return _obj


