# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner_account import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount
from morpheus.models.snapshots_instance200_response_snapshots_inner_snapshot_files_inner import SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInner
from typing import Optional, Set
from typing_extensions import Self

class SnapshotsInstance200ResponseSnapshotsInner(BaseModel):
    """
    SnapshotsInstance200ResponseSnapshotsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    status: Optional[StrictStr] = None
    state: Optional[StrictStr] = None
    snapshot_type: Optional[StrictStr] = Field(default=None, alias="snapshotType")
    snapshot_created: Optional[datetime] = Field(default=None, alias="snapshotCreated")
    zone: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount] = None
    datastore: Optional[StrictStr] = None
    parent_snapshot: Optional[StrictStr] = Field(default=None, alias="parentSnapshot")
    snapshot_files: Optional[List[SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInner]] = Field(default=None, alias="snapshotFiles")
    currently_active: Optional[StrictBool] = Field(default=None, alias="currentlyActive")
    memory_snapshot: Optional[StrictBool] = Field(default=None, alias="memorySnapshot")
    for_export: Optional[StrictBool] = Field(default=None, alias="forExport")
    for_backup: Optional[StrictBool] = Field(default=None, alias="forBackup")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "externalId", "status", "state", "snapshotType", "snapshotCreated", "zone", "datastore", "parentSnapshot", "snapshotFiles", "currentlyActive", "memorySnapshot", "forExport", "forBackup", "dateCreated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SnapshotsInstance200ResponseSnapshotsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in snapshot_files (list)
        _items = []
        if self.snapshot_files:
            for _item_snapshot_files in self.snapshot_files:
                if _item_snapshot_files:
                    _items.append(_item_snapshot_files.to_dict())
            _dict['snapshotFiles'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if snapshot_created (nullable) is None
        # and model_fields_set contains the field
        if self.snapshot_created is None and "snapshot_created" in self.model_fields_set:
            _dict['snapshotCreated'] = None

        # set to None if datastore (nullable) is None
        # and model_fields_set contains the field
        if self.datastore is None and "datastore" in self.model_fields_set:
            _dict['datastore'] = None

        # set to None if parent_snapshot (nullable) is None
        # and model_fields_set contains the field
        if self.parent_snapshot is None and "parent_snapshot" in self.model_fields_set:
            _dict['parentSnapshot'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SnapshotsInstance200ResponseSnapshotsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "externalId": obj.get("externalId"),
            "status": obj.get("status"),
            "state": obj.get("state"),
            "snapshotType": obj.get("snapshotType"),
            "snapshotCreated": obj.get("snapshotCreated"),
            "zone": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "datastore": obj.get("datastore"),
            "parentSnapshot": obj.get("parentSnapshot"),
            "snapshotFiles": [SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInner.from_dict(_item) for _item in obj["snapshotFiles"]] if obj.get("snapshotFiles") is not None else None,
            "currentlyActive": obj.get("currentlyActive"),
            "memorySnapshot": obj.get("memorySnapshot"),
            "forExport": obj.get("forExport"),
            "forBackup": obj.get("forBackup"),
            "dateCreated": obj.get("dateCreated")
        })
        return _obj


