# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_backup_settings_request_backup_settings_default_schedule import UpdateBackupSettingsRequestBackupSettingsDefaultSchedule
from morpheus.models.update_backup_settings_request_backup_settings_default_storage_bucket import UpdateBackupSettingsRequestBackupSettingsDefaultStorageBucket
from typing import Optional, Set
from typing_extensions import Self

class UpdateBackupSettingsRequestBackupSettings(BaseModel):
    """
    UpdateBackupSettingsRequestBackupSettings
    """ # noqa: E501
    backups_enabled: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable scheduled backups", alias="backupsEnabled")
    retention_count: Optional[StrictInt] = Field(default=None, description="Maximum number of successful backups to retain", alias="retentionCount")
    create_backups: Optional[StrictBool] = Field(default=None, description="Use this to enable / disable create backups", alias="createBackups")
    backup_appliance: Optional[StrictBool] = Field(default=None, description="When enabled, a Backup will be created to backup the Morpheus appliance database", alias="backupAppliance")
    update_existing: Optional[StrictBool] = Field(default=None, description="Use this to update existing backups with new settings", alias="updateExisting")
    default_schedule: Optional[UpdateBackupSettingsRequestBackupSettingsDefaultSchedule] = Field(default=None, alias="defaultSchedule")
    clear_default_schedule: Optional[StrictBool] = Field(default=None, description="Use this to clear existing default backup schedule", alias="clearDefaultSchedule")
    default_storage_bucket: Optional[UpdateBackupSettingsRequestBackupSettingsDefaultStorageBucket] = Field(default=None, alias="defaultStorageBucket")
    clear_default_storage_bucket: Optional[StrictBool] = Field(default=None, description="Use this to clear default store bucket", alias="clearDefaultStorageBucket")
    __properties: ClassVar[List[str]] = ["backupsEnabled", "retentionCount", "createBackups", "backupAppliance", "updateExisting", "defaultSchedule", "clearDefaultSchedule", "defaultStorageBucket", "clearDefaultStorageBucket"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateBackupSettingsRequestBackupSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_schedule
        if self.default_schedule:
            _dict['defaultSchedule'] = self.default_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_storage_bucket
        if self.default_storage_bucket:
            _dict['defaultStorageBucket'] = self.default_storage_bucket.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateBackupSettingsRequestBackupSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "backupsEnabled": obj.get("backupsEnabled"),
            "retentionCount": obj.get("retentionCount"),
            "createBackups": obj.get("createBackups"),
            "backupAppliance": obj.get("backupAppliance"),
            "updateExisting": obj.get("updateExisting"),
            "defaultSchedule": UpdateBackupSettingsRequestBackupSettingsDefaultSchedule.from_dict(obj["defaultSchedule"]) if obj.get("defaultSchedule") is not None else None,
            "clearDefaultSchedule": obj.get("clearDefaultSchedule"),
            "defaultStorageBucket": UpdateBackupSettingsRequestBackupSettingsDefaultStorageBucket.from_dict(obj["defaultStorageBucket"]) if obj.get("defaultStorageBucket") is not None else None,
            "clearDefaultStorageBucket": obj.get("clearDefaultStorageBucket")
        })
        return _obj


