# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_evars_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner
from morpheus.models.update_host_install_agent_request_server_server_os import UpdateHostInstallAgentRequestServerServerOs
from morpheus.models.update_host_managed_request_server_account import UpdateHostManagedRequestServerAccount
from morpheus.models.update_host_managed_request_server_config import UpdateHostManagedRequestServerConfig
from morpheus.models.update_host_managed_request_server_plan import UpdateHostManagedRequestServerPlan
from typing import Optional, Set
from typing_extensions import Self

class UpdateHostManagedRequestServer(BaseModel):
    """
    Object containing server configuration parameters
    """ # noqa: E501
    ssh_username: Optional[StrictStr] = Field(default=None, description="SSH username to use when provisioning", alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, description="SSH password to use, if not specified the account public key can be used", alias="sshPassword")
    server_os: Optional[UpdateHostInstallAgentRequestServerServerOs] = Field(default=None, alias="serverOs")
    plan: Optional[UpdateHostManagedRequestServerPlan] = None
    account: Optional[UpdateHostManagedRequestServerAccount] = None
    provision_site_id: Optional[StrictInt] = Field(default=None, description="Specific group to assign the server", alias="provisionSiteId")
    tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Metadata tags, Array of objects having a name and value, this adds or updates the specified tags and removes any tags not specified.")
    config: Optional[UpdateHostManagedRequestServerConfig] = None
    __properties: ClassVar[List[str]] = ["sshUsername", "sshPassword", "serverOs", "plan", "account", "provisionSiteId", "tags", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateHostManagedRequestServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of server_os
        if self.server_os:
            _dict['serverOs'] = self.server_os.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateHostManagedRequestServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "serverOs": UpdateHostInstallAgentRequestServerServerOs.from_dict(obj["serverOs"]) if obj.get("serverOs") is not None else None,
            "plan": UpdateHostManagedRequestServerPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "account": UpdateHostManagedRequestServerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "provisionSiteId": obj.get("provisionSiteId"),
            "tags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "config": UpdateHostManagedRequestServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        return _obj


