# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_instance_network_interface200_response_all_of_one_of_server_capacity_info import UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo
from morpheus.models.update_instance_network_interface200_response_all_of_one_of_server_compute_server_type import UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerComputeServerType
from morpheus.models.update_instance_network_interface200_response_all_of_one_of_server_interfaces_inner import UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerInterfacesInner
from morpheus.models.update_instance_network_interface200_response_all_of_one_of_server_zone import UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceNetworkInterface200ResponseAllOfOneOfServer(BaseModel):
    """
    UpdateInstanceNetworkInterface200ResponseAllOfOneOfServer
    """ # noqa: E501
    id: Optional[StrictInt] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    site_id: Optional[StrictInt] = Field(default=None, alias="siteId")
    ssh_host: Optional[StrictStr] = Field(default=None, alias="sshHost")
    ssh_port: Optional[StrictInt] = Field(default=None, alias="sshPort")
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    volume_id: Optional[StrictStr] = Field(default=None, alias="volumeId")
    platform: Optional[StrictStr] = None
    platform_version: Optional[StrictStr] = Field(default=None, alias="platformVersion")
    ssh_username: Optional[StrictStr] = Field(default=None, alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, alias="sshPassword")
    os_device: Optional[StrictStr] = Field(default=None, alias="osDevice")
    data_device: Optional[StrictStr] = Field(default=None, alias="dataDevice")
    lvm_enabled: Optional[StrictBool] = Field(default=None, alias="lvmEnabled")
    api_key: Optional[StrictStr] = Field(default=None, alias="apiKey")
    software_raid: Optional[StrictBool] = Field(default=None, alias="softwareRaid")
    config: Optional[StrictStr] = None
    capacity_info: Optional[UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo] = Field(default=None, alias="capacityInfo")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_stats: Optional[StrictStr] = Field(default=None, alias="lastStats")
    status: Optional[StrictStr] = None
    compute_server_type: Optional[UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerComputeServerType] = Field(default=None, alias="computeServerType")
    interfaces: Optional[List[UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerInterfacesInner]] = None
    zone: Optional[UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone] = None
    __properties: ClassVar[List[str]] = ["id", "externalId", "accountId", "name", "displayName", "visibility", "description", "zoneId", "siteId", "sshHost", "sshPort", "externalIp", "internalIp", "volumeId", "platform", "platformVersion", "sshUsername", "sshPassword", "osDevice", "dataDevice", "lvmEnabled", "apiKey", "softwareRaid", "config", "capacityInfo", "dateCreated", "lastUpdated", "lastStats", "status", "computeServerType", "interfaces", "zone"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of capacity_info
        if self.capacity_info:
            _dict['capacityInfo'] = self.capacity_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compute_server_type
        if self.compute_server_type:
            _dict['computeServerType'] = self.compute_server_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in interfaces (list)
        _items = []
        if self.interfaces:
            for _item_interfaces in self.interfaces:
                if _item_interfaces:
                    _items.append(_item_interfaces.to_dict())
            _dict['interfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if volume_id (nullable) is None
        # and model_fields_set contains the field
        if self.volume_id is None and "volume_id" in self.model_fields_set:
            _dict['volumeId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "externalId": obj.get("externalId"),
            "accountId": obj.get("accountId"),
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "zoneId": obj.get("zoneId"),
            "siteId": obj.get("siteId"),
            "sshHost": obj.get("sshHost"),
            "sshPort": obj.get("sshPort"),
            "externalIp": obj.get("externalIp"),
            "internalIp": obj.get("internalIp"),
            "volumeId": obj.get("volumeId"),
            "platform": obj.get("platform"),
            "platformVersion": obj.get("platformVersion"),
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "osDevice": obj.get("osDevice"),
            "dataDevice": obj.get("dataDevice"),
            "lvmEnabled": obj.get("lvmEnabled"),
            "apiKey": obj.get("apiKey"),
            "softwareRaid": obj.get("softwareRaid"),
            "config": obj.get("config"),
            "capacityInfo": UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo.from_dict(obj["capacityInfo"]) if obj.get("capacityInfo") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastStats": obj.get("lastStats"),
            "status": obj.get("status"),
            "computeServerType": UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerComputeServerType.from_dict(obj["computeServerType"]) if obj.get("computeServerType") is not None else None,
            "interfaces": [UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerInterfacesInner.from_dict(_item) for _item in obj["interfaces"]] if obj.get("interfaces") is not None else None,
            "zone": UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZone.from_dict(obj["zone"]) if obj.get("zone") is not None else None
        })
        return _obj


