# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo(BaseModel):
    """
    UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo
    """ # noqa: E501
    id: Optional[StrictInt] = None
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    server: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    used_storage: Optional[StrictInt] = Field(default=None, alias="usedStorage")
    version: Optional[StrictStr] = None
    max_cpu: Optional[StrictStr] = Field(default=None, alias="maxCpu")
    used_cores: Optional[StrictInt] = Field(default=None, alias="usedCores")
    used_memory: Optional[StrictInt] = Field(default=None, alias="usedMemory")
    max_cores: Optional[StrictInt] = Field(default=None, alias="maxCores")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    __properties: ClassVar[List[str]] = ["id", "maxMemory", "server", "usedStorage", "version", "maxCpu", "usedCores", "usedMemory", "maxCores", "maxStorage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerCapacityInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "maxMemory": obj.get("maxMemory"),
            "server": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "usedStorage": obj.get("usedStorage"),
            "version": obj.get("version"),
            "maxCpu": obj.get("maxCpu"),
            "usedCores": obj.get("usedCores"),
            "usedMemory": obj.get("usedMemory"),
            "maxCores": obj.get("maxCores"),
            "maxStorage": obj.get("maxStorage")
        })
        return _obj


