# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cluster_layouts_request_layout_environment_variables_inner import AddClusterLayoutsRequestLayoutEnvironmentVariablesInner
from morpheus.models.add_instance_type_request_instance_type_price_sets_inner import AddInstanceTypeRequestInstanceTypePriceSetsInner
from morpheus.models.add_layout_request_instance_type_layout_permissions import AddLayoutRequestInstanceTypeLayoutPermissions
from typing import Optional, Set
from typing_extensions import Self

class UpdateLayoutRequestInstanceTypeLayout(BaseModel):
    """
    UpdateLayoutRequestInstanceTypeLayout
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Layout name")
    labels: Optional[List[StrictStr]] = None
    instance_version: Optional[StrictStr] = Field(default=None, description="Version of the layout", alias="instanceVersion")
    description: Optional[StrictStr] = Field(default=None, description="Layout description")
    sort_order: Optional[StrictInt] = Field(default=None, description="Display order of the layout, higher to lower", alias="sortOrder")
    creatable: Optional[StrictBool] = Field(default=True, description="Can be used to enable / disable the creatability of the layout.")
    provision_type_code: Optional[StrictStr] = Field(default=None, description="Provision type code", alias="provisionTypeCode")
    memory_requirement: Optional[StrictStr] = Field(default=None, description="Memory requirement in megabytes", alias="memoryRequirement")
    has_auto_scale: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable the horizontal scaling.", alias="hasAutoScale")
    supports_convert_to_managed: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable the supports convert to managed.", alias="supportsConvertToManaged")
    container_types: Optional[List[StrictInt]] = Field(default=None, description="Array of layout node type IDs", alias="containerTypes")
    option_types: Optional[List[StrictInt]] = Field(default=None, description="Array of layout option type IDs", alias="optionTypes")
    spec_templates: Optional[List[StrictInt]] = Field(default=None, description="Array of layout spec template IDs", alias="specTemplates")
    environment_variables: Optional[List[AddClusterLayoutsRequestLayoutEnvironmentVariablesInner]] = Field(default=None, description="The environmentVariables parameter is array of env objects", alias="environmentVariables")
    price_sets: Optional[List[AddInstanceTypeRequestInstanceTypePriceSetsInner]] = Field(default=None, description="Array of price set objects", alias="priceSets")
    permissions: Optional[AddLayoutRequestInstanceTypeLayoutPermissions] = None
    __properties: ClassVar[List[str]] = ["name", "labels", "instanceVersion", "description", "sortOrder", "creatable", "provisionTypeCode", "memoryRequirement", "hasAutoScale", "supportsConvertToManaged", "containerTypes", "optionTypes", "specTemplates", "environmentVariables", "priceSets", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateLayoutRequestInstanceTypeLayout from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environment_variables (list)
        _items = []
        if self.environment_variables:
            for _item_environment_variables in self.environment_variables:
                if _item_environment_variables:
                    _items.append(_item_environment_variables.to_dict())
            _dict['environmentVariables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_sets (list)
        _items = []
        if self.price_sets:
            for _item_price_sets in self.price_sets:
                if _item_price_sets:
                    _items.append(_item_price_sets.to_dict())
            _dict['priceSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateLayoutRequestInstanceTypeLayout from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "instanceVersion": obj.get("instanceVersion"),
            "description": obj.get("description"),
            "sortOrder": obj.get("sortOrder"),
            "creatable": obj.get("creatable") if obj.get("creatable") is not None else True,
            "provisionTypeCode": obj.get("provisionTypeCode"),
            "memoryRequirement": obj.get("memoryRequirement"),
            "hasAutoScale": obj.get("hasAutoScale") if obj.get("hasAutoScale") is not None else False,
            "supportsConvertToManaged": obj.get("supportsConvertToManaged") if obj.get("supportsConvertToManaged") is not None else False,
            "containerTypes": obj.get("containerTypes"),
            "optionTypes": obj.get("optionTypes"),
            "specTemplates": obj.get("specTemplates"),
            "environmentVariables": [AddClusterLayoutsRequestLayoutEnvironmentVariablesInner.from_dict(_item) for _item in obj["environmentVariables"]] if obj.get("environmentVariables") is not None else None,
            "priceSets": [AddInstanceTypeRequestInstanceTypePriceSetsInner.from_dict(_item) for _item in obj["priceSets"]] if obj.get("priceSets") is not None else None,
            "permissions": AddLayoutRequestInstanceTypeLayoutPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None
        })
        return _obj


