# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_policies_group_request_policy_policy_type_config import UpdatePoliciesGroupRequestPolicyPolicyTypeConfig
from typing import Optional, Set
from typing_extensions import Self

class UpdatePoliciesCloudRequestPolicyPolicyType(BaseModel):
    """
    UpdatePoliciesCloudRequestPolicyPolicyType
    """ # noqa: E501
    code: Optional[StrictStr] = Field(default=None, description="The policy type")
    config: Optional[UpdatePoliciesGroupRequestPolicyPolicyTypeConfig] = None
    enabled: Optional[StrictBool] = Field(default=True, description="Set to false to disable")
    ref_type: Optional[StrictStr] = Field(default=None, description="Scope object type", alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, description="Scope object ID (`cloud`)", alias="refId")
    accounts: Optional[List[StrictInt]] = Field(default=None, description="Array of tenants to scope the policy to")
    each_user: Optional[StrictBool] = Field(default=None, description="Apply individually to each user in role.  Only when `refType` equals `Role`", alias="eachUser")
    __properties: ClassVar[List[str]] = ["code", "config", "enabled", "refType", "refId", "accounts", "eachUser"]

    @field_validator('code')
    def code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Approve Delete', 'Approve Provision', 'Approve Reconfigure', 'Backup Creation', 'Backup Targets', 'Budget', 'Cluster Resource Name', 'Cypher Access', 'Delayed Delete', 'Expiration', 'File Share Storage Quota', 'Hostname', 'Instance Name', 'Max Containers', 'Max Cores', 'Max Hosts', 'Max Load Balancer Pools', 'Max Memory', 'Max Pool Members', 'Max Storage', 'Max Virtual Servers', 'Max VMs', 'Message of the Day', 'Network Quota', 'Object Storage Quota', 'Power Schedule', 'Router Quota', 'Shutdown', 'Storage Server Storage Quota', 'Tags', 'User Creation', 'User Group Creation', 'Workflow']):
            raise ValueError("must be one of enum values ('Approve Delete', 'Approve Provision', 'Approve Reconfigure', 'Backup Creation', 'Backup Targets', 'Budget', 'Cluster Resource Name', 'Cypher Access', 'Delayed Delete', 'Expiration', 'File Share Storage Quota', 'Hostname', 'Instance Name', 'Max Containers', 'Max Cores', 'Max Hosts', 'Max Load Balancer Pools', 'Max Memory', 'Max Pool Members', 'Max Storage', 'Max Virtual Servers', 'Max VMs', 'Message of the Day', 'Network Quota', 'Object Storage Quota', 'Power Schedule', 'Router Quota', 'Shutdown', 'Storage Server Storage Quota', 'Tags', 'User Creation', 'User Group Creation', 'Workflow')")
        return value

    @field_validator('ref_type')
    def ref_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ComputeZone']):
            raise ValueError("must be one of enum values ('ComputeZone')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePoliciesCloudRequestPolicyPolicyType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePoliciesCloudRequestPolicyPolicyType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code"),
            "config": UpdatePoliciesGroupRequestPolicyPolicyTypeConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "accounts": obj.get("accounts"),
            "eachUser": obj.get("eachUser")
        })
        return _obj


