# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from morpheus.models.default_blueprint_permission import DefaultBlueprintPermission
from morpheus.models.default_catalog_item_type_permission import DefaultCatalogItemTypePermission
from morpheus.models.default_cloud_permission import DefaultCloudPermission
from morpheus.models.default_group_permission import DefaultGroupPermission
from morpheus.models.default_instance_type_permission import DefaultInstanceTypePermission
from morpheus.models.default_persona_permission import DefaultPersonaPermission
from morpheus.models.default_report_type_permission import DefaultReportTypePermission
from morpheus.models.default_task_permission import DefaultTaskPermission
from morpheus.models.default_vdi_pool_permission import DefaultVDIPoolPermission
from morpheus.models.default_workflow_permission import DefaultWorkflowPermission
from morpheus.models.feature_permission import FeaturePermission
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

UPDATEROLEPERMISSIONREQUEST_ONE_OF_SCHEMAS = ["DefaultBlueprintPermission", "DefaultCatalogItemTypePermission", "DefaultCloudPermission", "DefaultGroupPermission", "DefaultInstanceTypePermission", "DefaultPersonaPermission", "DefaultReportTypePermission", "DefaultTaskPermission", "DefaultVDIPoolPermission", "DefaultWorkflowPermission", "FeaturePermission"]

class UpdateRolePermissionRequest(BaseModel):
    """
    UpdateRolePermissionRequest
    """
    # data type: FeaturePermission
    oneof_schema_1_validator: Optional[FeaturePermission] = None
    # data type: DefaultGroupPermission
    oneof_schema_2_validator: Optional[DefaultGroupPermission] = None
    # data type: DefaultCloudPermission
    oneof_schema_3_validator: Optional[DefaultCloudPermission] = None
    # data type: DefaultInstanceTypePermission
    oneof_schema_4_validator: Optional[DefaultInstanceTypePermission] = None
    # data type: DefaultBlueprintPermission
    oneof_schema_5_validator: Optional[DefaultBlueprintPermission] = None
    # data type: DefaultReportTypePermission
    oneof_schema_6_validator: Optional[DefaultReportTypePermission] = None
    # data type: DefaultPersonaPermission
    oneof_schema_7_validator: Optional[DefaultPersonaPermission] = None
    # data type: DefaultCatalogItemTypePermission
    oneof_schema_8_validator: Optional[DefaultCatalogItemTypePermission] = None
    # data type: DefaultVDIPoolPermission
    oneof_schema_9_validator: Optional[DefaultVDIPoolPermission] = None
    # data type: DefaultWorkflowPermission
    oneof_schema_10_validator: Optional[DefaultWorkflowPermission] = None
    # data type: DefaultTaskPermission
    oneof_schema_11_validator: Optional[DefaultTaskPermission] = None
    actual_instance: Optional[Union[DefaultBlueprintPermission, DefaultCatalogItemTypePermission, DefaultCloudPermission, DefaultGroupPermission, DefaultInstanceTypePermission, DefaultPersonaPermission, DefaultReportTypePermission, DefaultTaskPermission, DefaultVDIPoolPermission, DefaultWorkflowPermission, FeaturePermission]] = None
    one_of_schemas: Set[str] = { "DefaultBlueprintPermission", "DefaultCatalogItemTypePermission", "DefaultCloudPermission", "DefaultGroupPermission", "DefaultInstanceTypePermission", "DefaultPersonaPermission", "DefaultReportTypePermission", "DefaultTaskPermission", "DefaultVDIPoolPermission", "DefaultWorkflowPermission", "FeaturePermission" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = UpdateRolePermissionRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: FeaturePermission
        if not isinstance(v, FeaturePermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FeaturePermission`")
        else:
            match += 1
        # validate data type: DefaultGroupPermission
        if not isinstance(v, DefaultGroupPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultGroupPermission`")
        else:
            match += 1
        # validate data type: DefaultCloudPermission
        if not isinstance(v, DefaultCloudPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultCloudPermission`")
        else:
            match += 1
        # validate data type: DefaultInstanceTypePermission
        if not isinstance(v, DefaultInstanceTypePermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultInstanceTypePermission`")
        else:
            match += 1
        # validate data type: DefaultBlueprintPermission
        if not isinstance(v, DefaultBlueprintPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultBlueprintPermission`")
        else:
            match += 1
        # validate data type: DefaultReportTypePermission
        if not isinstance(v, DefaultReportTypePermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultReportTypePermission`")
        else:
            match += 1
        # validate data type: DefaultPersonaPermission
        if not isinstance(v, DefaultPersonaPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultPersonaPermission`")
        else:
            match += 1
        # validate data type: DefaultCatalogItemTypePermission
        if not isinstance(v, DefaultCatalogItemTypePermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultCatalogItemTypePermission`")
        else:
            match += 1
        # validate data type: DefaultVDIPoolPermission
        if not isinstance(v, DefaultVDIPoolPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultVDIPoolPermission`")
        else:
            match += 1
        # validate data type: DefaultWorkflowPermission
        if not isinstance(v, DefaultWorkflowPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultWorkflowPermission`")
        else:
            match += 1
        # validate data type: DefaultTaskPermission
        if not isinstance(v, DefaultTaskPermission):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DefaultTaskPermission`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in UpdateRolePermissionRequest with oneOf schemas: DefaultBlueprintPermission, DefaultCatalogItemTypePermission, DefaultCloudPermission, DefaultGroupPermission, DefaultInstanceTypePermission, DefaultPersonaPermission, DefaultReportTypePermission, DefaultTaskPermission, DefaultVDIPoolPermission, DefaultWorkflowPermission, FeaturePermission. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in UpdateRolePermissionRequest with oneOf schemas: DefaultBlueprintPermission, DefaultCatalogItemTypePermission, DefaultCloudPermission, DefaultGroupPermission, DefaultInstanceTypePermission, DefaultPersonaPermission, DefaultReportTypePermission, DefaultTaskPermission, DefaultVDIPoolPermission, DefaultWorkflowPermission, FeaturePermission. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into FeaturePermission
        try:
            instance.actual_instance = FeaturePermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultGroupPermission
        try:
            instance.actual_instance = DefaultGroupPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultCloudPermission
        try:
            instance.actual_instance = DefaultCloudPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultInstanceTypePermission
        try:
            instance.actual_instance = DefaultInstanceTypePermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultBlueprintPermission
        try:
            instance.actual_instance = DefaultBlueprintPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultReportTypePermission
        try:
            instance.actual_instance = DefaultReportTypePermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultPersonaPermission
        try:
            instance.actual_instance = DefaultPersonaPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultCatalogItemTypePermission
        try:
            instance.actual_instance = DefaultCatalogItemTypePermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultVDIPoolPermission
        try:
            instance.actual_instance = DefaultVDIPoolPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultWorkflowPermission
        try:
            instance.actual_instance = DefaultWorkflowPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DefaultTaskPermission
        try:
            instance.actual_instance = DefaultTaskPermission.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into UpdateRolePermissionRequest with oneOf schemas: DefaultBlueprintPermission, DefaultCatalogItemTypePermission, DefaultCloudPermission, DefaultGroupPermission, DefaultInstanceTypePermission, DefaultPersonaPermission, DefaultReportTypePermission, DefaultTaskPermission, DefaultVDIPoolPermission, DefaultWorkflowPermission, FeaturePermission. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into UpdateRolePermissionRequest with oneOf schemas: DefaultBlueprintPermission, DefaultCatalogItemTypePermission, DefaultCloudPermission, DefaultGroupPermission, DefaultInstanceTypePermission, DefaultPersonaPermission, DefaultReportTypePermission, DefaultTaskPermission, DefaultVDIPoolPermission, DefaultWorkflowPermission, FeaturePermission. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DefaultBlueprintPermission, DefaultCatalogItemTypePermission, DefaultCloudPermission, DefaultGroupPermission, DefaultInstanceTypePermission, DefaultPersonaPermission, DefaultReportTypePermission, DefaultTaskPermission, DefaultVDIPoolPermission, DefaultWorkflowPermission, FeaturePermission]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


