# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_storage_buckets_request_storage_bucket_config import AddStorageBucketsRequestStorageBucketConfig
from typing import Optional, Set
from typing_extensions import Self

class UpdateStorageBucketsRequestStorageBucket(BaseModel):
    """
    UpdateStorageBucketsRequestStorageBucket
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A unique name scoped to your account for the storage bucket")
    provider_type: Optional[StrictStr] = Field(default=None, description="The type of storage bucket", alias="providerType")
    default_backup_target: Optional[StrictBool] = Field(default=False, description="Default Backup Target", alias="defaultBackupTarget")
    copy_to_store: Optional[StrictBool] = Field(default=None, description="Archive Snapshots", alias="copyToStore")
    default_deployment_target: Optional[StrictBool] = Field(default=False, description="Default Deployment Target", alias="defaultDeploymentTarget")
    default_virtual_image_target: Optional[StrictBool] = Field(default=False, description="Default Virtual Image Store", alias="defaultVirtualImageTarget")
    retention_policy_type: Optional[StrictStr] = Field(default='none', description="Cleanup mode. `backup` - Move old files to a backup provider. `delete` - Delete old files. `none` - Keep all files.", alias="retentionPolicyType")
    retention_policy_days: Optional[StrictInt] = Field(default=None, description="The number of days old a file must be before it is deleted.", alias="retentionPolicyDays")
    retention_provider: Optional[StrictStr] = Field(default=None, description="The backup Storage Bucket where old files are moved to.", alias="retentionProvider")
    bucket_name: Optional[StrictStr] = Field(default=None, description="The name of the bucket. Only applies to `Amazon`, `Azure`, `CIFS`, `NFSv3`, `Openstack Swift`, and `Rackspace CDN`.", alias="bucketName")
    create_bucket: Optional[StrictBool] = Field(default=False, description="Create the bucket if it does not exist. Only applies to `Amazon`, `Azure`, `Openstack Swift`, and `Rackspace CDN`.", alias="createBucket")
    config: Optional[AddStorageBucketsRequestStorageBucketConfig] = None
    __properties: ClassVar[List[str]] = ["name", "providerType", "defaultBackupTarget", "copyToStore", "defaultDeploymentTarget", "defaultVirtualImageTarget", "retentionPolicyType", "retentionPolicyDays", "retentionProvider", "bucketName", "createBucket", "config"]

    @field_validator('provider_type')
    def provider_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['s3', 'azure', 'cifs', 'local', 'nfs', 'openstack', 'rackspace']):
            raise ValueError("must be one of enum values ('s3', 'azure', 'cifs', 'local', 'nfs', 'openstack', 'rackspace')")
        return value

    @field_validator('retention_policy_type')
    def retention_policy_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['backup', 'delete', 'none']):
            raise ValueError("must be one of enum values ('backup', 'delete', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateStorageBucketsRequestStorageBucket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateStorageBucketsRequestStorageBucket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "providerType": obj.get("providerType"),
            "defaultBackupTarget": obj.get("defaultBackupTarget") if obj.get("defaultBackupTarget") is not None else False,
            "copyToStore": obj.get("copyToStore"),
            "defaultDeploymentTarget": obj.get("defaultDeploymentTarget") if obj.get("defaultDeploymentTarget") is not None else False,
            "defaultVirtualImageTarget": obj.get("defaultVirtualImageTarget") if obj.get("defaultVirtualImageTarget") is not None else False,
            "retentionPolicyType": obj.get("retentionPolicyType") if obj.get("retentionPolicyType") is not None else 'none',
            "retentionPolicyDays": obj.get("retentionPolicyDays"),
            "retentionProvider": obj.get("retentionProvider"),
            "bucketName": obj.get("bucketName"),
            "createBucket": obj.get("createBucket") if obj.get("createBucket") is not None else False,
            "config": AddStorageBucketsRequestStorageBucketConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        return _obj


