# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.add_integrations_request_one_of_integration_credential import AddIntegrationsRequestOneOfIntegrationCredential
from morpheus.models.add_tasks_request_task_file import AddTasksRequestTaskFile
from morpheus.models.add_tasks_request_task_task_type import AddTasksRequestTaskTaskType
from typing import Optional, Set
from typing_extensions import Self

class UpdateTasksRequestTask(BaseModel):
    """
    UpdateTasksRequestTask
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A unique name for the task")
    code: Optional[StrictStr] = Field(default=None, description="A unique code for the task")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility")
    task_type: Optional[AddTasksRequestTaskTaskType] = Field(default=None, alias="taskType")
    labels: Optional[List[StrictStr]] = Field(default=None, description="An array of Category labels for filtering")
    task_options: Optional[Dict[str, Any]] = Field(default=None, description="Map of options specific to each `task type`. eg. script", alias="taskOptions")
    result_type: Optional[StrictStr] = Field(default=None, alias="resultType")
    execute_target: Optional[StrictStr] = Field(default=None, description="The execution target. eg. local,remote,resource. The default value varies by task type. ", alias="executeTarget")
    retryable: Optional[StrictBool] = Field(default=False, description="If the task should be retried or not.")
    retry_count: Optional[StrictInt] = Field(default=None, description="The number of times to retry.", alias="retryCount")
    retry_delay_seconds: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The delay, between retries.", alias="retryDelaySeconds")
    file: Optional[AddTasksRequestTaskFile] = None
    credential: Optional[AddIntegrationsRequestOneOfIntegrationCredential] = None
    __properties: ClassVar[List[str]] = ["name", "code", "visibility", "taskType", "labels", "taskOptions", "resultType", "executeTarget", "retryable", "retryCount", "retryDelaySeconds", "file", "credential"]

    @field_validator('result_type')
    def result_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['exitCode', 'keyValue', 'json']):
            raise ValueError("must be one of enum values ('exitCode', 'keyValue', 'json')")
        return value

    @field_validator('execute_target')
    def execute_target_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['local', 'remote', 'resource']):
            raise ValueError("must be one of enum values ('local', 'remote', 'resource')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateTasksRequestTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of task_type
        if self.task_type:
            _dict['taskType'] = self.task_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # set to None if result_type (nullable) is None
        # and model_fields_set contains the field
        if self.result_type is None and "result_type" in self.model_fields_set:
            _dict['resultType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateTasksRequestTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "taskType": AddTasksRequestTaskTaskType.from_dict(obj["taskType"]) if obj.get("taskType") is not None else None,
            "labels": obj.get("labels"),
            "taskOptions": obj.get("taskOptions"),
            "resultType": obj.get("resultType"),
            "executeTarget": obj.get("executeTarget"),
            "retryable": obj.get("retryable") if obj.get("retryable") is not None else False,
            "retryCount": obj.get("retryCount"),
            "retryDelaySeconds": obj.get("retryDelaySeconds"),
            "file": AddTasksRequestTaskFile.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "credential": AddIntegrationsRequestOneOfIntegrationCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None
        })
        return _obj


