# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_user_settings_request_user_default_cloud import UpdateUserSettingsRequestUserDefaultCloud
from morpheus.models.update_user_settings_request_user_default_group import UpdateUserSettingsRequestUserDefaultGroup
from morpheus.models.update_user_settings_request_user_default_persona import UpdateUserSettingsRequestUserDefaultPersona
from typing import Optional, Set
from typing_extensions import Self

class UpdateUserSettingsRequestUser(BaseModel):
    """
    UpdateUserSettingsRequestUser
    """ # noqa: E501
    username: Optional[StrictStr] = Field(default=None, description="Username")
    email: Optional[StrictStr] = Field(default=None, description="Email")
    first_name: Optional[StrictStr] = Field(default=None, description="First Name", alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, description="Last Name", alias="lastName")
    password: Optional[StrictStr] = Field(default=None, description="Change your password")
    linux_username: Optional[StrictStr] = Field(default=None, description="Linux Username", alias="linuxUsername")
    linux_password: Optional[StrictStr] = Field(default=None, description="Linux Password", alias="linuxPassword")
    linux_key_pair_id: Optional[StrictInt] = Field(default=None, description="Linux Key Pair ID", alias="linuxKeyPairId")
    windows_username: Optional[StrictStr] = Field(default=None, description="Windows Username", alias="windowsUsername")
    windows_password: Optional[StrictStr] = Field(default=None, description="Windows Password", alias="windowsPassword")
    receive_notifications: Optional[StrictBool] = Field(default=None, description="Receive Notifications (true or false)", alias="receiveNotifications")
    default_group: Optional[UpdateUserSettingsRequestUserDefaultGroup] = Field(default=None, alias="defaultGroup")
    default_cloud: Optional[UpdateUserSettingsRequestUserDefaultCloud] = Field(default=None, alias="defaultCloud")
    default_persona: Optional[UpdateUserSettingsRequestUserDefaultPersona] = Field(default=None, alias="defaultPersona")
    __properties: ClassVar[List[str]] = ["username", "email", "firstName", "lastName", "password", "linuxUsername", "linuxPassword", "linuxKeyPairId", "windowsUsername", "windowsPassword", "receiveNotifications", "defaultGroup", "defaultCloud", "defaultPersona"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateUserSettingsRequestUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_group
        if self.default_group:
            _dict['defaultGroup'] = self.default_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_cloud
        if self.default_cloud:
            _dict['defaultCloud'] = self.default_cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_persona
        if self.default_persona:
            _dict['defaultPersona'] = self.default_persona.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateUserSettingsRequestUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "email": obj.get("email"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "password": obj.get("password"),
            "linuxUsername": obj.get("linuxUsername"),
            "linuxPassword": obj.get("linuxPassword"),
            "linuxKeyPairId": obj.get("linuxKeyPairId"),
            "windowsUsername": obj.get("windowsUsername"),
            "windowsPassword": obj.get("windowsPassword"),
            "receiveNotifications": obj.get("receiveNotifications"),
            "defaultGroup": UpdateUserSettingsRequestUserDefaultGroup.from_dict(obj["defaultGroup"]) if obj.get("defaultGroup") is not None else None,
            "defaultCloud": UpdateUserSettingsRequestUserDefaultCloud.from_dict(obj["defaultCloud"]) if obj.get("defaultCloud") is not None else None,
            "defaultPersona": UpdateUserSettingsRequestUserDefaultPersona.from_dict(obj["defaultPersona"]) if obj.get("defaultPersona") is not None else None
        })
        return _obj


