# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_baremetal_host_request_server_cloud import AddBaremetalHostRequestServerCloud
from morpheus.models.add_baremetal_host_request_server_compute_server_type import AddBaremetalHostRequestServerComputeServerType
from morpheus.models.add_baremetal_host_request_server_config import AddBaremetalHostRequestServerConfig
from morpheus.models.add_baremetal_host_request_server_group import AddBaremetalHostRequestServerGroup
from typing import Optional, Set
from typing_extensions import Self

class AddBaremetalHostRequestServer(BaseModel):
    """
    AddBaremetalHostRequestServer
    """ # noqa: E501
    cloud: Optional[AddBaremetalHostRequestServerCloud] = None
    compute_server_type: Optional[AddBaremetalHostRequestServerComputeServerType] = Field(default=None, alias="computeServerType")
    description: Optional[StrictStr] = None
    group: Optional[AddBaremetalHostRequestServerGroup] = None
    labels: Optional[List[StrictStr]] = None
    name: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    config: Optional[AddBaremetalHostRequestServerConfig] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["cloud", "computeServerType", "description", "group", "labels", "name", "visibility", "config"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddBaremetalHostRequestServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compute_server_type
        if self.compute_server_type:
            _dict['computeServerType'] = self.compute_server_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddBaremetalHostRequestServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cloud": AddBaremetalHostRequestServerCloud.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "computeServerType": AddBaremetalHostRequestServerComputeServerType.from_dict(obj["computeServerType"]) if obj.get("computeServerType") is not None else None,
            "description": obj.get("description"),
            "group": AddBaremetalHostRequestServerGroup.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "labels": obj.get("labels"),
            "name": obj.get("name"),
            "visibility": obj.get("visibility"),
            "config": AddBaremetalHostRequestServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


