# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AddChecksRequestCheckOneOf1Config(BaseModel):
    """
    AddChecksRequestCheckOneOf1Config
    """ # noqa: E501
    db_host: StrictStr = Field(description="Hostname or IP address of the database", alias="dbHost")
    db_port: StrictStr = Field(description="Database Port (defaults to default port of DB type selected)", alias="dbPort")
    db_user: StrictStr = Field(description="Database username", alias="dbUser")
    db_password: StrictStr = Field(description="Database password, (all check data is encrypted inside the database)", alias="dbPassword")
    db_password_hash: Optional[StrictStr] = Field(default=None, description="Database password hash", alias="dbPasswordHash")
    db_name: StrictStr = Field(description="Database name you would like to connect to", alias="dbName")
    db_query: StrictStr = Field(description="Query to test", alias="dbQuery")
    check_operator: Optional[StrictStr] = Field(default=None, description="Can be set to `lt` (less than), `gt` (greater than), `equal` (Equal to) for comparison", alias="checkOperator")
    check_result: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="checkResult")
    check_user: Optional[StrictStr] = Field(default=None, alias="checkUser")
    text_check_on: Optional[StrictStr] = Field(default=None, alias="textCheckOn")
    check_password: Optional[StrictStr] = Field(default=None, alias="checkPassword")
    web_text_match: Optional[StrictStr] = Field(default=None, alias="webTextMatch")
    check_password_hash: Optional[StrictStr] = Field(default=None, alias="checkPasswordHash")
    tunnel_on: Optional[StrictStr] = Field(default=None, alias="tunnelOn")
    ssh_host: Optional[StrictStr] = Field(default=None, alias="sshHost")
    ssh_port: Optional[StrictInt] = Field(default=None, alias="sshPort")
    ssh_user: Optional[StrictStr] = Field(default=None, alias="sshUser")
    ssh_password: Optional[StrictStr] = Field(default=None, description="Password for user, if not using key based authentication", alias="sshPassword")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["dbHost", "dbPort", "dbUser", "dbPassword", "dbPasswordHash", "dbName", "dbQuery", "checkOperator", "checkResult", "checkUser", "textCheckOn", "checkPassword", "webTextMatch", "checkPasswordHash", "tunnelOn", "sshHost", "sshPort", "sshUser", "sshPassword"]

    @field_validator('check_operator')
    def check_operator_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['lt', 'gt', 'equal']):
            raise ValueError("must be one of enum values ('lt', 'gt', 'equal')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddChecksRequestCheckOneOf1Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddChecksRequestCheckOneOf1Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dbHost": obj.get("dbHost"),
            "dbPort": obj.get("dbPort"),
            "dbUser": obj.get("dbUser"),
            "dbPassword": obj.get("dbPassword"),
            "dbPasswordHash": obj.get("dbPasswordHash"),
            "dbName": obj.get("dbName"),
            "dbQuery": obj.get("dbQuery"),
            "checkOperator": obj.get("checkOperator"),
            "checkResult": obj.get("checkResult"),
            "checkUser": obj.get("checkUser"),
            "textCheckOn": obj.get("textCheckOn"),
            "checkPassword": obj.get("checkPassword"),
            "webTextMatch": obj.get("webTextMatch"),
            "checkPasswordHash": obj.get("checkPasswordHash"),
            "tunnelOn": obj.get("tunnelOn"),
            "sshHost": obj.get("sshHost"),
            "sshPort": obj.get("sshPort"),
            "sshUser": obj.get("sshUser"),
            "sshPassword": obj.get("sshPassword")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


