# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_evars_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_service_plan_options import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigServicePlanOptions
from morpheus.models.add_cluster_request_cluster_server_config import AddClusterRequestClusterServerConfig
from morpheus.models.add_cluster_request_cluster_server_network_interfaces_inner import AddClusterRequestClusterServerNetworkInterfacesInner
from morpheus.models.add_cluster_request_cluster_server_plan import AddClusterRequestClusterServerPlan
from morpheus.models.add_cluster_request_cluster_server_server_type import AddClusterRequestClusterServerServerType
from morpheus.models.add_cluster_request_cluster_server_ssh_hosts_inner import AddClusterRequestClusterServerSshHostsInner
from morpheus.models.add_cluster_request_cluster_server_ssh_key_pair import AddClusterRequestClusterServerSshKeyPair
from morpheus.models.add_cluster_request_cluster_server_user_group import AddClusterRequestClusterServerUserGroup
from morpheus.models.add_cluster_request_cluster_server_volumes_inner import AddClusterRequestClusterServerVolumesInner
from typing import Optional, Set
from typing_extensions import Self

class AddClusterRequestClusterServer(BaseModel):
    """
    AddClusterRequestClusterServer
    """ # noqa: E501
    config: AddClusterRequestClusterServerConfig
    server_type: Optional[AddClusterRequestClusterServerServerType] = Field(default=None, alias="serverType")
    name: StrictStr = Field(description="Name to be used for host(s) created in the cluster")
    plan: AddClusterRequestClusterServerPlan
    service_plan_options: Optional[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigServicePlanOptions] = Field(default=None, alias="servicePlanOptions")
    volumes: Optional[List[AddClusterRequestClusterServerVolumesInner]] = Field(default=None, description="The (optional) volumes parameter is for LV configuration, can create additional LVs at provision It should be passed as an array of Objects")
    network_interfaces: Optional[List[AddClusterRequestClusterServerNetworkInterfacesInner]] = Field(default=None, description="The networkInterfaces parameter is for network configuration.  The Options API /api/options/zoneNetworkOptions can be used to see which options are available.  It should be passed as an array of Objects with the following attributes ", alias="networkInterfaces")
    security_groups: Optional[List[StrictStr]] = Field(default=None, description="Key for security group configuration.", alias="securityGroups")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility for server host")
    user_group: Optional[AddClusterRequestClusterServerUserGroup] = Field(default=None, alias="userGroup")
    network_domain: Optional[StrictStr] = Field(default=None, description="Network domain", alias="networkDomain")
    hostname: Optional[StrictStr] = Field(default=None, description="Hostname for server host")
    node_count: Optional[StrictInt] = Field(default=None, description="Number of workers or hosts", alias="nodeCount")
    tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Metadata tags, Array of objects having a name and value.")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of strings (keywords). This will set labels on the server and also on the cluster as well by default.")
    ssh_hosts: Optional[List[AddClusterRequestClusterServerSshHostsInner]] = Field(default=None, description="Array of Host IPs and Names. This is used in conjunction with sshUsername and sshPassword/sshKeyPair to add existing hosts such as with HPE VM clusters.", alias="sshHosts")
    ssh_username: Optional[StrictStr] = Field(default=None, description="SSH Username", alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, description="SSH Password", alias="sshPassword")
    ssh_key_pair: Optional[AddClusterRequestClusterServerSshKeyPair] = Field(default=None, alias="sshKeyPair")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["config", "serverType", "name", "plan", "servicePlanOptions", "volumes", "networkInterfaces", "securityGroups", "visibility", "userGroup", "networkDomain", "hostname", "nodeCount", "tags", "labels", "sshHosts", "sshUsername", "sshPassword", "sshKeyPair"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddClusterRequestClusterServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server_type
        if self.server_type:
            _dict['serverType'] = self.server_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_plan_options
        if self.service_plan_options:
            _dict['servicePlanOptions'] = self.service_plan_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in network_interfaces (list)
        _items = []
        if self.network_interfaces:
            for _item_network_interfaces in self.network_interfaces:
                if _item_network_interfaces:
                    _items.append(_item_network_interfaces.to_dict())
            _dict['networkInterfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of user_group
        if self.user_group:
            _dict['userGroup'] = self.user_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ssh_hosts (list)
        _items = []
        if self.ssh_hosts:
            for _item_ssh_hosts in self.ssh_hosts:
                if _item_ssh_hosts:
                    _items.append(_item_ssh_hosts.to_dict())
            _dict['sshHosts'] = _items
        # override the default output from pydantic by calling `to_dict()` of ssh_key_pair
        if self.ssh_key_pair:
            _dict['sshKeyPair'] = self.ssh_key_pair.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if network_domain (nullable) is None
        # and model_fields_set contains the field
        if self.network_domain is None and "network_domain" in self.model_fields_set:
            _dict['networkDomain'] = None

        # set to None if hostname (nullable) is None
        # and model_fields_set contains the field
        if self.hostname is None and "hostname" in self.model_fields_set:
            _dict['hostname'] = None

        # set to None if ssh_password (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_password is None and "ssh_password" in self.model_fields_set:
            _dict['sshPassword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddClusterRequestClusterServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "config": AddClusterRequestClusterServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "serverType": AddClusterRequestClusterServerServerType.from_dict(obj["serverType"]) if obj.get("serverType") is not None else None,
            "name": obj.get("name"),
            "plan": AddClusterRequestClusterServerPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "servicePlanOptions": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigServicePlanOptions.from_dict(obj["servicePlanOptions"]) if obj.get("servicePlanOptions") is not None else None,
            "volumes": [AddClusterRequestClusterServerVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "networkInterfaces": [AddClusterRequestClusterServerNetworkInterfacesInner.from_dict(_item) for _item in obj["networkInterfaces"]] if obj.get("networkInterfaces") is not None else None,
            "securityGroups": obj.get("securityGroups"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "userGroup": AddClusterRequestClusterServerUserGroup.from_dict(obj["userGroup"]) if obj.get("userGroup") is not None else None,
            "networkDomain": obj.get("networkDomain"),
            "hostname": obj.get("hostname"),
            "nodeCount": obj.get("nodeCount"),
            "tags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "labels": obj.get("labels"),
            "sshHosts": [AddClusterRequestClusterServerSshHostsInner.from_dict(_item) for _item in obj["sshHosts"]] if obj.get("sshHosts") is not None else None,
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "sshKeyPair": AddClusterRequestClusterServerSshKeyPair.from_dict(obj["sshKeyPair"]) if obj.get("sshKeyPair") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


