# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from morpheus.models.add_integrations_request_one_of import AddIntegrationsRequestOneOf
from morpheus.models.add_integrations_request_one_of1 import AddIntegrationsRequestOneOf1
from morpheus.models.add_integrations_request_one_of2 import AddIntegrationsRequestOneOf2
from morpheus.models.add_integrations_request_one_of3 import AddIntegrationsRequestOneOf3
from morpheus.models.add_integrations_request_one_of4 import AddIntegrationsRequestOneOf4
from morpheus.models.add_integrations_request_one_of5 import AddIntegrationsRequestOneOf5
from morpheus.models.add_integrations_request_one_of6 import AddIntegrationsRequestOneOf6
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ADDINTEGRATIONSREQUEST_ONE_OF_SCHEMAS = ["AddIntegrationsRequestOneOf", "AddIntegrationsRequestOneOf1", "AddIntegrationsRequestOneOf2", "AddIntegrationsRequestOneOf3", "AddIntegrationsRequestOneOf4", "AddIntegrationsRequestOneOf5", "AddIntegrationsRequestOneOf6"]

class AddIntegrationsRequest(BaseModel):
    """
    AddIntegrationsRequest
    """
    # data type: AddIntegrationsRequestOneOf
    oneof_schema_1_validator: Optional[AddIntegrationsRequestOneOf] = None
    # data type: AddIntegrationsRequestOneOf1
    oneof_schema_2_validator: Optional[AddIntegrationsRequestOneOf1] = None
    # data type: AddIntegrationsRequestOneOf2
    oneof_schema_3_validator: Optional[AddIntegrationsRequestOneOf2] = None
    # data type: AddIntegrationsRequestOneOf3
    oneof_schema_4_validator: Optional[AddIntegrationsRequestOneOf3] = None
    # data type: AddIntegrationsRequestOneOf4
    oneof_schema_5_validator: Optional[AddIntegrationsRequestOneOf4] = None
    # data type: AddIntegrationsRequestOneOf5
    oneof_schema_6_validator: Optional[AddIntegrationsRequestOneOf5] = None
    # data type: AddIntegrationsRequestOneOf6
    oneof_schema_7_validator: Optional[AddIntegrationsRequestOneOf6] = None
    actual_instance: Optional[Union[AddIntegrationsRequestOneOf, AddIntegrationsRequestOneOf1, AddIntegrationsRequestOneOf2, AddIntegrationsRequestOneOf3, AddIntegrationsRequestOneOf4, AddIntegrationsRequestOneOf5, AddIntegrationsRequestOneOf6]] = None
    one_of_schemas: Set[str] = { "AddIntegrationsRequestOneOf", "AddIntegrationsRequestOneOf1", "AddIntegrationsRequestOneOf2", "AddIntegrationsRequestOneOf3", "AddIntegrationsRequestOneOf4", "AddIntegrationsRequestOneOf5", "AddIntegrationsRequestOneOf6" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AddIntegrationsRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: AddIntegrationsRequestOneOf
        if not isinstance(v, AddIntegrationsRequestOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf`")
        else:
            match += 1
        # validate data type: AddIntegrationsRequestOneOf1
        if not isinstance(v, AddIntegrationsRequestOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf1`")
        else:
            match += 1
        # validate data type: AddIntegrationsRequestOneOf2
        if not isinstance(v, AddIntegrationsRequestOneOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf2`")
        else:
            match += 1
        # validate data type: AddIntegrationsRequestOneOf3
        if not isinstance(v, AddIntegrationsRequestOneOf3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf3`")
        else:
            match += 1
        # validate data type: AddIntegrationsRequestOneOf4
        if not isinstance(v, AddIntegrationsRequestOneOf4):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf4`")
        else:
            match += 1
        # validate data type: AddIntegrationsRequestOneOf5
        if not isinstance(v, AddIntegrationsRequestOneOf5):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf5`")
        else:
            match += 1
        # validate data type: AddIntegrationsRequestOneOf6
        if not isinstance(v, AddIntegrationsRequestOneOf6):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddIntegrationsRequestOneOf6`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AddIntegrationsRequest with oneOf schemas: AddIntegrationsRequestOneOf, AddIntegrationsRequestOneOf1, AddIntegrationsRequestOneOf2, AddIntegrationsRequestOneOf3, AddIntegrationsRequestOneOf4, AddIntegrationsRequestOneOf5, AddIntegrationsRequestOneOf6. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AddIntegrationsRequest with oneOf schemas: AddIntegrationsRequestOneOf, AddIntegrationsRequestOneOf1, AddIntegrationsRequestOneOf2, AddIntegrationsRequestOneOf3, AddIntegrationsRequestOneOf4, AddIntegrationsRequestOneOf5, AddIntegrationsRequestOneOf6. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AddIntegrationsRequestOneOf
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddIntegrationsRequestOneOf1
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddIntegrationsRequestOneOf2
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddIntegrationsRequestOneOf3
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddIntegrationsRequestOneOf4
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf4.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddIntegrationsRequestOneOf5
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf5.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddIntegrationsRequestOneOf6
        try:
            instance.actual_instance = AddIntegrationsRequestOneOf6.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AddIntegrationsRequest with oneOf schemas: AddIntegrationsRequestOneOf, AddIntegrationsRequestOneOf1, AddIntegrationsRequestOneOf2, AddIntegrationsRequestOneOf3, AddIntegrationsRequestOneOf4, AddIntegrationsRequestOneOf5, AddIntegrationsRequestOneOf6. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddIntegrationsRequest with oneOf schemas: AddIntegrationsRequestOneOf, AddIntegrationsRequestOneOf1, AddIntegrationsRequestOneOf2, AddIntegrationsRequestOneOf3, AddIntegrationsRequestOneOf4, AddIntegrationsRequestOneOf5, AddIntegrationsRequestOneOf6. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AddIntegrationsRequestOneOf, AddIntegrationsRequestOneOf1, AddIntegrationsRequestOneOf2, AddIntegrationsRequestOneOf3, AddIntegrationsRequestOneOf4, AddIntegrationsRequestOneOf5, AddIntegrationsRequestOneOf6]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


