# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AddPoliciesGroupRequestPolicyPolicyTypeConfigOneOf24(BaseModel):
    """
    - Shutdown 
    """ # noqa: E501
    shutdown_type: Optional[StrictStr] = Field(default=None, alias="shutdownType")
    shutdown_age: Optional[StrictStr] = Field(default=None, alias="shutdownAge")
    shutdown_renewal: Optional[StrictStr] = Field(default=None, alias="shutdownRenewal")
    shutdown_notify: Optional[StrictStr] = Field(default=None, alias="shutdownNotify")
    shutdown_message: Optional[StrictStr] = Field(default=None, alias="shutdownMessage")
    shutdown_auto_renew: Optional[StrictStr] = Field(default='off', alias="shutdownAutoRenew")
    shutdown_allow_extend: Optional[StrictStr] = Field(default='off', alias="shutdownAllowExtend")
    shutdown_extensions_before_approval: Optional[StrictStr] = Field(default=None, alias="shutdownExtensionsBeforeApproval")
    account_integration_id: Optional[StrictStr] = Field(default=None, alias="accountIntegrationId")
    shutdown_hide_fixed: Optional[StrictBool] = Field(default=None, alias="shutdownHideFixed")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["shutdownType", "shutdownAge", "shutdownRenewal", "shutdownNotify", "shutdownMessage", "shutdownAutoRenew", "shutdownAllowExtend", "shutdownExtensionsBeforeApproval", "accountIntegrationId", "shutdownHideFixed"]

    @field_validator('shutdown_auto_renew')
    def shutdown_auto_renew_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    @field_validator('shutdown_allow_extend')
    def shutdown_allow_extend_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddPoliciesGroupRequestPolicyPolicyTypeConfigOneOf24 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddPoliciesGroupRequestPolicyPolicyTypeConfigOneOf24 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shutdownType": obj.get("shutdownType"),
            "shutdownAge": obj.get("shutdownAge"),
            "shutdownRenewal": obj.get("shutdownRenewal"),
            "shutdownNotify": obj.get("shutdownNotify"),
            "shutdownMessage": obj.get("shutdownMessage"),
            "shutdownAutoRenew": obj.get("shutdownAutoRenew") if obj.get("shutdownAutoRenew") is not None else 'off',
            "shutdownAllowExtend": obj.get("shutdownAllowExtend") if obj.get("shutdownAllowExtend") is not None else 'off',
            "shutdownExtensionsBeforeApproval": obj.get("shutdownExtensionsBeforeApproval"),
            "accountIntegrationId": obj.get("accountIntegrationId"),
            "shutdownHideFixed": obj.get("shutdownHideFixed")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


