# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.add_prices_request_price_account import AddPricesRequestPriceAccount
from morpheus.models.add_prices_request_price_datastore import AddPricesRequestPriceDatastore
from morpheus.models.add_prices_request_price_volume_type import AddPricesRequestPriceVolumeType
from typing import Optional, Set
from typing_extensions import Self

class AddPricesRequestPrice(BaseModel):
    """
    AddPricesRequestPrice
    """ # noqa: E501
    name: StrictStr = Field(description="Price name")
    code: StrictStr = Field(description="Price code, must be unique")
    account: Optional[AddPricesRequestPriceAccount] = None
    price_type: StrictStr = Field(description="Restricts query to only load only prices with specified priceType. * `fixed` - Everything * `compute` - Memory + CPU * `memory` - Memory * `cores` - Cores * `storage` - Storage * `datastore` - Datastore * `platform` - Platform * `software` - Software * `load_balancer` - Load Balancer * `load_balancer_virtual_server` - Load Balancer Virtual Server ", alias="priceType")
    price_unit: StrictStr = Field(description="The unit of pricing", alias="priceUnit")
    incur_charges: StrictStr = Field(description="Indicates when to incur charge", alias="incurCharges")
    currency: StrictStr = Field(description="ISO Currency code")
    cost: Union[StrictFloat, StrictInt] = Field(description="Cost")
    markup_type: Optional[StrictStr] = Field(default=None, description="Price adjustment type", alias="markupType")
    markup: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount for `fixed` price adjustment type")
    markup_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percent for `percent` price adjustment type", alias="markupPercent")
    custom_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Custom price for `custom` price adjustment type", alias="customPrice")
    platform: Optional[StrictStr] = Field(default=None, description="Platform.  Required for `platform` price type")
    software: Optional[StrictStr] = Field(default=None, description="Software.  Required for software price type")
    volume_type: Optional[AddPricesRequestPriceVolumeType] = Field(default=None, alias="volumeType")
    datastore: Optional[AddPricesRequestPriceDatastore] = None
    cross_cloud_apply: Optional[StrictBool] = Field(default=None, description="Apply price across clouds, optional true/false flag for datastore price type", alias="crossCloudApply")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "code", "account", "priceType", "priceUnit", "incurCharges", "currency", "cost", "markupType", "markup", "markupPercent", "customPrice", "platform", "software", "volumeType", "datastore", "crossCloudApply"]

    @field_validator('price_type')
    def price_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['fixed', 'compute', 'memory', 'cores', 'storage', 'datastore', 'platform', 'software', 'load_balancer', 'load_balancer_virtual_server']):
            raise ValueError("must be one of enum values ('fixed', 'compute', 'memory', 'cores', 'storage', 'datastore', 'platform', 'software', 'load_balancer', 'load_balancer_virtual_server')")
        return value

    @field_validator('price_unit')
    def price_unit_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['minute', 'hour', 'day', 'month', 'year', 'two year', 'three year', 'four year', 'five year']):
            raise ValueError("must be one of enum values ('minute', 'hour', 'day', 'month', 'year', 'two year', 'three year', 'four year', 'five year')")
        return value

    @field_validator('incur_charges')
    def incur_charges_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['running', 'stopped', 'always']):
            raise ValueError("must be one of enum values ('running', 'stopped', 'always')")
        return value

    @field_validator('markup_type')
    def markup_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['fixed', 'percent', 'custom']):
            raise ValueError("must be one of enum values ('fixed', 'percent', 'custom')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddPricesRequestPrice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of volume_type
        if self.volume_type:
            _dict['volumeType'] = self.volume_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of datastore
        if self.datastore:
            _dict['datastore'] = self.datastore.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddPricesRequestPrice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "account": AddPricesRequestPriceAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "priceType": obj.get("priceType"),
            "priceUnit": obj.get("priceUnit"),
            "incurCharges": obj.get("incurCharges"),
            "currency": obj.get("currency"),
            "cost": obj.get("cost"),
            "markupType": obj.get("markupType"),
            "markup": obj.get("markup"),
            "markupPercent": obj.get("markupPercent"),
            "customPrice": obj.get("customPrice"),
            "platform": obj.get("platform"),
            "software": obj.get("software"),
            "volumeType": AddPricesRequestPriceVolumeType.from_dict(obj["volumeType"]) if obj.get("volumeType") is not None else None,
            "datastore": AddPricesRequestPriceDatastore.from_dict(obj["datastore"]) if obj.get("datastore") is not None else None,
            "crossCloudApply": obj.get("crossCloudApply")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


