# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from morpheus.models.add_spec_template_request_spec_template_config_cloudformation_capabilityautoexpand import AddSpecTemplateRequestSpecTemplateConfigCloudformationCAPABILITYAUTOEXPAND
from morpheus.models.add_spec_template_request_spec_template_config_cloudformation_capabilitynamediam import AddSpecTemplateRequestSpecTemplateConfigCloudformationCAPABILITYNAMEDIAM
from morpheus.models.add_spec_template_request_spec_template_config_cloudformation_iam import AddSpecTemplateRequestSpecTemplateConfigCloudformationIAM
from typing import Optional, Set
from typing_extensions import Self

class AddSpecTemplateRequestSpecTemplateConfigCloudformation(BaseModel):
    """
    AddSpecTemplateRequestSpecTemplateConfigCloudformation
    """ # noqa: E501
    iam: AddSpecTemplateRequestSpecTemplateConfigCloudformationIAM = Field(alias="IAM")
    capability_named_iam: AddSpecTemplateRequestSpecTemplateConfigCloudformationCAPABILITYNAMEDIAM = Field(alias="CAPABILITY_NAMED_IAM")
    capability_auto_expand: AddSpecTemplateRequestSpecTemplateConfigCloudformationCAPABILITYAUTOEXPAND = Field(alias="CAPABILITY_AUTO_EXPAND")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["IAM", "CAPABILITY_NAMED_IAM", "CAPABILITY_AUTO_EXPAND"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddSpecTemplateRequestSpecTemplateConfigCloudformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of iam
        if self.iam:
            _dict['IAM'] = self.iam.to_dict()
        # override the default output from pydantic by calling `to_dict()` of capability_named_iam
        if self.capability_named_iam:
            _dict['CAPABILITY_NAMED_IAM'] = self.capability_named_iam.to_dict()
        # override the default output from pydantic by calling `to_dict()` of capability_auto_expand
        if self.capability_auto_expand:
            _dict['CAPABILITY_AUTO_EXPAND'] = self.capability_auto_expand.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddSpecTemplateRequestSpecTemplateConfigCloudformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "IAM": AddSpecTemplateRequestSpecTemplateConfigCloudformationIAM.from_dict(obj["IAM"]) if obj.get("IAM") is not None else None,
            "CAPABILITY_NAMED_IAM": AddSpecTemplateRequestSpecTemplateConfigCloudformationCAPABILITYNAMEDIAM.from_dict(obj["CAPABILITY_NAMED_IAM"]) if obj.get("CAPABILITY_NAMED_IAM") is not None else None,
            "CAPABILITY_AUTO_EXPAND": AddSpecTemplateRequestSpecTemplateConfigCloudformationCAPABILITYAUTOEXPAND.from_dict(obj["CAPABILITY_AUTO_EXPAND"]) if obj.get("CAPABILITY_AUTO_EXPAND") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


