# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_user_tenant200_response_all_of_user_access import AddUserTenant200ResponseAllOfUserAccess
from morpheus.models.add_user_tenant200_response_all_of_user_roles_inner import AddUserTenant200ResponseAllOfUserRolesInner
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class AddUserTenant200ResponseAllOfUser(BaseModel):
    """
    AddUserTenant200ResponseAllOfUser
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    username: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    email: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    enabled: Optional[StrictBool] = None
    receive_notifications: Optional[StrictBool] = Field(default=None, alias="receiveNotifications")
    is_using2_fa: Optional[StrictBool] = Field(default=None, alias="isUsing2FA")
    account_expired: Optional[StrictBool] = Field(default=None, alias="accountExpired")
    account_locked: Optional[StrictBool] = Field(default=None, alias="accountLocked")
    password_expired: Optional[StrictBool] = Field(default=None, alias="passwordExpired")
    login_count: Optional[StrictInt] = Field(default=None, alias="loginCount")
    login_attempts: Optional[StrictInt] = Field(default=None, alias="loginAttempts")
    last_login_date: Optional[datetime] = Field(default=None, alias="lastLoginDate")
    roles: Optional[List[AddUserTenant200ResponseAllOfUserRolesInner]] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    linux_username: Optional[StrictStr] = Field(default=None, alias="linuxUsername")
    linux_password: Optional[StrictStr] = Field(default=None, alias="linuxPassword")
    linux_key_pair_id: Optional[StrictInt] = Field(default=None, alias="linuxKeyPairId")
    windows_username: Optional[StrictStr] = Field(default=None, alias="windowsUsername")
    windows_password: Optional[StrictStr] = Field(default=None, alias="windowsPassword")
    default_persona: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="defaultPersona")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    access: Optional[AddUserTenant200ResponseAllOfUserAccess] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "accountId", "username", "displayName", "email", "firstName", "lastName", "enabled", "receiveNotifications", "isUsing2FA", "accountExpired", "accountLocked", "passwordExpired", "loginCount", "loginAttempts", "lastLoginDate", "roles", "account", "linuxUsername", "linuxPassword", "linuxKeyPairId", "windowsUsername", "windowsPassword", "defaultPersona", "dateCreated", "lastUpdated", "access"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddUserTenant200ResponseAllOfUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item_roles in self.roles:
                if _item_roles:
                    _items.append(_item_roles.to_dict())
            _dict['roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_persona
        if self.default_persona:
            _dict['defaultPersona'] = self.default_persona.to_dict()
        # override the default output from pydantic by calling `to_dict()` of access
        if self.access:
            _dict['access'] = self.access.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if linux_username (nullable) is None
        # and model_fields_set contains the field
        if self.linux_username is None and "linux_username" in self.model_fields_set:
            _dict['linuxUsername'] = None

        # set to None if linux_password (nullable) is None
        # and model_fields_set contains the field
        if self.linux_password is None and "linux_password" in self.model_fields_set:
            _dict['linuxPassword'] = None

        # set to None if linux_key_pair_id (nullable) is None
        # and model_fields_set contains the field
        if self.linux_key_pair_id is None and "linux_key_pair_id" in self.model_fields_set:
            _dict['linuxKeyPairId'] = None

        # set to None if windows_username (nullable) is None
        # and model_fields_set contains the field
        if self.windows_username is None and "windows_username" in self.model_fields_set:
            _dict['windowsUsername'] = None

        # set to None if windows_password (nullable) is None
        # and model_fields_set contains the field
        if self.windows_password is None and "windows_password" in self.model_fields_set:
            _dict['windowsPassword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddUserTenant200ResponseAllOfUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "username": obj.get("username"),
            "displayName": obj.get("displayName"),
            "email": obj.get("email"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "enabled": obj.get("enabled"),
            "receiveNotifications": obj.get("receiveNotifications"),
            "isUsing2FA": obj.get("isUsing2FA"),
            "accountExpired": obj.get("accountExpired"),
            "accountLocked": obj.get("accountLocked"),
            "passwordExpired": obj.get("passwordExpired"),
            "loginCount": obj.get("loginCount"),
            "loginAttempts": obj.get("loginAttempts"),
            "lastLoginDate": obj.get("lastLoginDate"),
            "roles": [AddUserTenant200ResponseAllOfUserRolesInner.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "linuxUsername": obj.get("linuxUsername"),
            "linuxPassword": obj.get("linuxPassword"),
            "linuxKeyPairId": obj.get("linuxKeyPairId"),
            "windowsUsername": obj.get("windowsUsername"),
            "windowsPassword": obj.get("windowsPassword"),
            "defaultPersona": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["defaultPersona"]) if obj.get("defaultPersona") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "access": AddUserTenant200ResponseAllOfUserAccess.from_dict(obj["access"]) if obj.get("access") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


