# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_workflows_request_task_set_tasks_inner import AddWorkflowsRequestTaskSetTasksInner
from typing import Optional, Set
from typing_extensions import Self

class AddWorkflowsRequestTaskSet(BaseModel):
    """
    AddWorkflowsRequestTaskSet
    """ # noqa: E501
    name: StrictStr = Field(description="A unique name for the workflow")
    description: Optional[StrictStr] = Field(default=None, description="A description of the workflow")
    labels: Optional[List[StrictStr]] = Field(default=None, description="An array of Category labels for filtering")
    type: Optional[StrictStr] = Field(default='provision', description="Workflow type")
    visibility: Optional[StrictStr] = Field(default='private', description="private or public")
    option_types: Optional[List[StrictInt]] = Field(default=None, description="List of option type IDs for use with operational workflow configuration.", alias="optionTypes")
    tasks: Optional[List[AddWorkflowsRequestTaskSetTasksInner]] = Field(default=None, description="List of task objects in order")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "labels", "type", "visibility", "optionTypes", "tasks"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['provision', 'operation']):
            raise ValueError("must be one of enum values ('provision', 'operation')")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddWorkflowsRequestTaskSet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item_tasks in self.tasks:
                if _item_tasks:
                    _items.append(_item_tasks.to_dict())
            _dict['tasks'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddWorkflowsRequestTaskSet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "type": obj.get("type") if obj.get("type") is not None else 'provision',
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "optionTypes": obj.get("optionTypes"),
            "tasks": [AddWorkflowsRequestTaskSetTasksInner.from_dict(_item) for _item in obj["tasks"]] if obj.get("tasks") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


