# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_apps_request_blueprint_id import AddAppsRequestBlueprintId
from morpheus.models.add_apps_request_default_cloud import AddAppsRequestDefaultCloud
from morpheus.models.add_apps_request_group import AddAppsRequestGroup
from typing import Optional, Set
from typing_extensions import Self

class AppCreate(BaseModel):
    """
    AppCreate
    """ # noqa: E501
    template_id: Optional[StrictInt] = Field(default=None, alias="templateId")
    blueprint_id: AddAppsRequestBlueprintId = Field(alias="blueprintId")
    name: StrictStr = Field(description="A unique name for the app")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    group: Optional[AddAppsRequestGroup] = None
    default_cloud: Optional[AddAppsRequestDefaultCloud] = Field(default=None, alias="defaultCloud")
    environment: Optional[StrictStr] = Field(default=None, description="Environment code (appContext)")
    tiers: Optional[Dict[str, Any]] = Field(default=None, description="Configuration of app elements")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["templateId", "blueprintId", "name", "description", "labels", "group", "defaultCloud", "environment", "tiers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of blueprint_id
        if self.blueprint_id:
            _dict['blueprintId'] = self.blueprint_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_cloud
        if self.default_cloud:
            _dict['defaultCloud'] = self.default_cloud.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "templateId": obj.get("templateId"),
            "blueprintId": AddAppsRequestBlueprintId.from_dict(obj["blueprintId"]) if obj.get("blueprintId") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "group": AddAppsRequestGroup.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "defaultCloud": AddAppsRequestDefaultCloud.from_dict(obj["defaultCloud"]) if obj.get("defaultCloud") is not None else None,
            "environment": obj.get("environment"),
            "tiers": obj.get("tiers")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


