# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.backup_instance_backup_job import BackupInstanceBackupJob
from typing import Optional, Set
from typing_extensions import Self

class BackupInstance(BaseModel):
    """
    BackupInstance
    """ # noqa: E501
    location_type: StrictStr = Field(alias="locationType")
    name: StrictStr = Field(description="A name for the backup")
    instance_id: StrictInt = Field(description="The ID of the instance to backup", alias="instanceId")
    container_id: StrictInt = Field(description="The ID of the container to backup", alias="containerId")
    backup_type: StrictStr = Field(description="The backup type code, options vary by the type of cloud and source", alias="backupType")
    job_action: StrictStr = Field(description="Create a new backup job, clone an existing job or add the new backup to an existing job", alias="jobAction")
    job_id: Optional[StrictInt] = Field(default=None, description="The ID of the job to clone or add to. Only applies to jobAction `clone` and `addTo`.", alias="jobId")
    job_name: Optional[StrictStr] = Field(default=None, description="Name for new job. Only applies to jobAction `new` and `clone`.", alias="jobName")
    job_schedule: Optional[StrictInt] = Field(default=None, description="The ID of the execute schedule for new job. See Execute Schedules. Only applies to jobAction `new` and `clone`.", alias="jobSchedule")
    retention_count: Optional[StrictInt] = Field(default=None, description="Retention Count for new job. By default the backup settings value will be used. Only applies to jobAction `new` and `clone`.", alias="retentionCount")
    backup_job: Optional[BackupInstanceBackupJob] = Field(default=None, alias="backupJob")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["locationType", "name", "instanceId", "containerId", "backupType", "jobAction", "jobId", "jobName", "jobSchedule", "retentionCount", "backupJob"]

    @field_validator('location_type')
    def location_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['instance']):
            raise ValueError("must be one of enum values ('instance')")
        return value

    @field_validator('backup_type')
    def backup_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['alibabaSnapshot', 'amazonSnapshot', 'avamarVMWareBackup', 'azureSnapshot', 'bluemixSnapshot', 'commvaultFileBackup', 'commvaultOpenstackBackup', 'commvaultVMWareBackup', 'digitaloceanSnapshot', 'directoryBackup', 'esxiSnapshot', 'fileBackup', 'fusionSnapshot', 'googleSnapshot', 'huaweiSnapshot', 'hypervSnapshot', 'kvm', 'lvmImage', 'lvmMigration', 'lvmSnapshot', 'MongoDB', 'morpheusAppliance', 'morpheusContainerBackup', 'morpheusStorageBackup', 'morpheusVmBackup', 'MySQL', 'nutanixSnapshot', 'openstackSnapshot', 'opentelekomSnapshot', 'oracleCloudSnapshot', 'Postgres', 'powervcSnapshot', 'rubrikVMWareBackup', 'scvmmSnapshot', 'softlayerSnapshot', 'SqlServer', 'tarDirectoryBackup', 'upCloudSnapshot', 'vcdSnapshot', 'veeamHypervBackup', 'veeamScvmmBackup', 'veeamVcdBackup', 'veeamVMWareBackup', 'virtustreamSnapshot', 'vmwareSnapshot', 'winMigration', 'xenSnapshot']):
            raise ValueError("must be one of enum values ('alibabaSnapshot', 'amazonSnapshot', 'avamarVMWareBackup', 'azureSnapshot', 'bluemixSnapshot', 'commvaultFileBackup', 'commvaultOpenstackBackup', 'commvaultVMWareBackup', 'digitaloceanSnapshot', 'directoryBackup', 'esxiSnapshot', 'fileBackup', 'fusionSnapshot', 'googleSnapshot', 'huaweiSnapshot', 'hypervSnapshot', 'kvm', 'lvmImage', 'lvmMigration', 'lvmSnapshot', 'MongoDB', 'morpheusAppliance', 'morpheusContainerBackup', 'morpheusStorageBackup', 'morpheusVmBackup', 'MySQL', 'nutanixSnapshot', 'openstackSnapshot', 'opentelekomSnapshot', 'oracleCloudSnapshot', 'Postgres', 'powervcSnapshot', 'rubrikVMWareBackup', 'scvmmSnapshot', 'softlayerSnapshot', 'SqlServer', 'tarDirectoryBackup', 'upCloudSnapshot', 'vcdSnapshot', 'veeamHypervBackup', 'veeamScvmmBackup', 'veeamVcdBackup', 'veeamVMWareBackup', 'virtustreamSnapshot', 'vmwareSnapshot', 'winMigration', 'xenSnapshot')")
        return value

    @field_validator('job_action')
    def job_action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['new', 'clone', 'addTo']):
            raise ValueError("must be one of enum values ('new', 'clone', 'addTo')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackupInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of backup_job
        if self.backup_job:
            _dict['backupJob'] = self.backup_job.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackupInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "locationType": obj.get("locationType"),
            "name": obj.get("name"),
            "instanceId": obj.get("instanceId"),
            "containerId": obj.get("containerId"),
            "backupType": obj.get("backupType"),
            "jobAction": obj.get("jobAction"),
            "jobId": obj.get("jobId"),
            "jobName": obj.get("jobName"),
            "jobSchedule": obj.get("jobSchedule"),
            "retentionCount": obj.get("retentionCount"),
            "backupJob": BackupInstanceBackupJob.from_dict(obj["backupJob"]) if obj.get("backupJob") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


