# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.list_billing_account200_response_all_of_billing_info_zones_inner_compute_servers import ListBillingAccount200ResponseAllOfBillingInfoZonesInnerComputeServers
from morpheus.models.list_billing_account200_response_all_of_billing_info_zones_inner_instances import ListBillingAccount200ResponseAllOfBillingInfoZonesInnerInstances
from morpheus.models.list_billing_account200_response_all_of_billing_info_zones_inner_load_balancers import ListBillingAccount200ResponseAllOfBillingInfoZonesInnerLoadBalancers
from morpheus.models.list_billing_account200_response_all_of_billing_info_zones_inner_snapshots import ListBillingAccount200ResponseAllOfBillingInfoZonesInnerSnapshots
from morpheus.models.list_billing_account200_response_all_of_billing_info_zones_inner_virtual_images import ListBillingAccount200ResponseAllOfBillingInfoZonesInnerVirtualImages
from typing import Optional, Set
from typing_extensions import Self

class BillingZone(BaseModel):
    """
    BillingZone
    """ # noqa: E501
    zone_name: Optional[StrictStr] = Field(default=None, alias="zoneName")
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    zone_uuid: Optional[StrictStr] = Field(default=None, alias="zoneUUID")
    zone_code: Optional[StrictStr] = Field(default=None, alias="zoneCode")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    price_unit: Optional[StrictStr] = Field(default=None, alias="priceUnit")
    compute_servers: Optional[ListBillingAccount200ResponseAllOfBillingInfoZonesInnerComputeServers] = Field(default=None, alias="computeServers")
    instances: Optional[ListBillingAccount200ResponseAllOfBillingInfoZonesInnerInstances] = None
    discovered_servers: Optional[ListBillingAccount200ResponseAllOfBillingInfoZonesInnerComputeServers] = Field(default=None, alias="discoveredServers")
    load_balancers: Optional[ListBillingAccount200ResponseAllOfBillingInfoZonesInnerLoadBalancers] = Field(default=None, alias="loadBalancers")
    virtual_images: Optional[ListBillingAccount200ResponseAllOfBillingInfoZonesInnerVirtualImages] = Field(default=None, alias="virtualImages")
    snapshots: Optional[ListBillingAccount200ResponseAllOfBillingInfoZonesInnerSnapshots] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    cost: Optional[Union[StrictFloat, StrictInt]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["zoneName", "zoneId", "zoneUUID", "zoneCode", "startDate", "endDate", "priceUnit", "computeServers", "instances", "discoveredServers", "loadBalancers", "virtualImages", "snapshots", "price", "cost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingZone from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of compute_servers
        if self.compute_servers:
            _dict['computeServers'] = self.compute_servers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instances
        if self.instances:
            _dict['instances'] = self.instances.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discovered_servers
        if self.discovered_servers:
            _dict['discoveredServers'] = self.discovered_servers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of load_balancers
        if self.load_balancers:
            _dict['loadBalancers'] = self.load_balancers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_images
        if self.virtual_images:
            _dict['virtualImages'] = self.virtual_images.to_dict()
        # override the default output from pydantic by calling `to_dict()` of snapshots
        if self.snapshots:
            _dict['snapshots'] = self.snapshots.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if zone_code (nullable) is None
        # and model_fields_set contains the field
        if self.zone_code is None and "zone_code" in self.model_fields_set:
            _dict['zoneCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingZone from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "zoneName": obj.get("zoneName"),
            "zoneId": obj.get("zoneId"),
            "zoneUUID": obj.get("zoneUUID"),
            "zoneCode": obj.get("zoneCode"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "priceUnit": obj.get("priceUnit"),
            "computeServers": ListBillingAccount200ResponseAllOfBillingInfoZonesInnerComputeServers.from_dict(obj["computeServers"]) if obj.get("computeServers") is not None else None,
            "instances": ListBillingAccount200ResponseAllOfBillingInfoZonesInnerInstances.from_dict(obj["instances"]) if obj.get("instances") is not None else None,
            "discoveredServers": ListBillingAccount200ResponseAllOfBillingInfoZonesInnerComputeServers.from_dict(obj["discoveredServers"]) if obj.get("discoveredServers") is not None else None,
            "loadBalancers": ListBillingAccount200ResponseAllOfBillingInfoZonesInnerLoadBalancers.from_dict(obj["loadBalancers"]) if obj.get("loadBalancers") is not None else None,
            "virtualImages": ListBillingAccount200ResponseAllOfBillingInfoZonesInnerVirtualImages.from_dict(obj["virtualImages"]) if obj.get("virtualImages") is not None else None,
            "snapshots": ListBillingAccount200ResponseAllOfBillingInfoZonesInnerSnapshots.from_dict(obj["snapshots"]) if obj.get("snapshots") is not None else None,
            "price": obj.get("price"),
            "cost": obj.get("cost")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


