# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ClusterApiConfig(BaseModel):
    """
    ClusterApiConfig
    """ # noqa: E501
    service_url: Optional[StrictStr] = Field(default=None, alias="serviceUrl")
    service_host: Optional[StrictStr] = Field(default=None, alias="serviceHost")
    service_path: Optional[StrictStr] = Field(default=None, alias="servicePath")
    service_hostname: Optional[StrictStr] = Field(default=None, alias="serviceHostname")
    service_port: Optional[StrictInt] = Field(default=None, alias="servicePort")
    service_username: Optional[StrictStr] = Field(default=None, alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, alias="servicePassword")
    service_password_hash: Optional[StrictStr] = Field(default=None, alias="servicePasswordHash")
    service_token: Optional[StrictStr] = Field(default=None, description="API Token", alias="serviceToken")
    service_access: Optional[StrictStr] = Field(default=None, description="Kube Config", alias="serviceAccess")
    service_cert: Optional[StrictStr] = Field(default=None, alias="serviceCert")
    service_version: Optional[StrictStr] = Field(default=None, alias="serviceVersion")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["serviceUrl", "serviceHost", "servicePath", "serviceHostname", "servicePort", "serviceUsername", "servicePassword", "servicePasswordHash", "serviceToken", "serviceAccess", "serviceCert", "serviceVersion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterApiConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_host (nullable) is None
        # and model_fields_set contains the field
        if self.service_host is None and "service_host" in self.model_fields_set:
            _dict['serviceHost'] = None

        # set to None if service_path (nullable) is None
        # and model_fields_set contains the field
        if self.service_path is None and "service_path" in self.model_fields_set:
            _dict['servicePath'] = None

        # set to None if service_hostname (nullable) is None
        # and model_fields_set contains the field
        if self.service_hostname is None and "service_hostname" in self.model_fields_set:
            _dict['serviceHostname'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if service_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_password_hash is None and "service_password_hash" in self.model_fields_set:
            _dict['servicePasswordHash'] = None

        # set to None if service_token (nullable) is None
        # and model_fields_set contains the field
        if self.service_token is None and "service_token" in self.model_fields_set:
            _dict['serviceToken'] = None

        # set to None if service_access (nullable) is None
        # and model_fields_set contains the field
        if self.service_access is None and "service_access" in self.model_fields_set:
            _dict['serviceAccess'] = None

        # set to None if service_cert (nullable) is None
        # and model_fields_set contains the field
        if self.service_cert is None and "service_cert" in self.model_fields_set:
            _dict['serviceCert'] = None

        # set to None if service_version (nullable) is None
        # and model_fields_set contains the field
        if self.service_version is None and "service_version" in self.model_fields_set:
            _dict['serviceVersion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterApiConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "serviceUrl": obj.get("serviceUrl"),
            "serviceHost": obj.get("serviceHost"),
            "servicePath": obj.get("servicePath"),
            "serviceHostname": obj.get("serviceHostname"),
            "servicePort": obj.get("servicePort"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "servicePasswordHash": obj.get("servicePasswordHash"),
            "serviceToken": obj.get("serviceToken"),
            "serviceAccess": obj.get("serviceAccess"),
            "serviceCert": obj.get("serviceCert"),
            "serviceVersion": obj.get("serviceVersion")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


