# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_cluster_request_cluster_integrations_inner import UpdateClusterRequestClusterIntegrationsInner
from typing import Optional, Set
from typing_extensions import Self

class ClusterUpdate(BaseModel):
    """
    ClusterUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Cluster name")
    description: Optional[StrictStr] = Field(default=None, description="Cluster description")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    enabled: Optional[StrictBool] = Field(default=None, description="Cluster enabled")
    use_agent: Optional[StrictBool] = Field(default=None, description="Use the Agent to relay communications for the Kubernetes API instead of direct.", alias="useAgent")
    service_url: Optional[StrictStr] = Field(default=None, description="Cluster API Url", alias="serviceUrl")
    service_token: Optional[StrictStr] = Field(default=None, description="Cluster API token", alias="serviceToken")
    refresh: Optional[StrictBool] = Field(default=None, description="Queue cluster refresh")
    managed: Optional[StrictBool] = Field(default=None, description="Cluster managed")
    auto_recover_power_state: Optional[StrictBool] = Field(default=None, description="Automatically Power on VMs", alias="autoRecoverPowerState")
    integrations: Optional[List[UpdateClusterRequestClusterIntegrationsInner]] = Field(default=None, description="Cluster integrations")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "labels", "enabled", "useAgent", "serviceUrl", "serviceToken", "refresh", "managed", "autoRecoverPowerState", "integrations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in integrations (list)
        _items = []
        if self.integrations:
            for _item_integrations in self.integrations:
                if _item_integrations:
                    _items.append(_item_integrations.to_dict())
            _dict['integrations'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "enabled": obj.get("enabled"),
            "useAgent": obj.get("useAgent"),
            "serviceUrl": obj.get("serviceUrl"),
            "serviceToken": obj.get("serviceToken"),
            "refresh": obj.get("refresh"),
            "managed": obj.get("managed"),
            "autoRecoverPowerState": obj.get("autoRecoverPowerState"),
            "integrations": [UpdateClusterRequestClusterIntegrationsInner.from_dict(_item) for _item in obj["integrations"]] if obj.get("integrations") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


