# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cluster_layouts_request_layout_environment_variables_inner import AddClusterLayoutsRequestLayoutEnvironmentVariablesInner
from morpheus.models.add_node_type_request_container_type_container_ports_inner import AddNodeTypeRequestContainerTypeContainerPortsInner
from typing import Optional, Set
from typing_extensions import Self

class ContainerTypeUpdate(BaseModel):
    """
    ContainerTypeUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Node type name")
    labels: Optional[List[StrictStr]] = None
    short_name: Optional[StrictStr] = Field(default=None, description="The short name is a name with no spaces used for display in your container list.", alias="shortName")
    description: Optional[StrictStr] = Field(default=None, description="Node type description")
    container_version: Optional[StrictStr] = Field(default=None, description="Version of the node type", alias="containerVersion")
    provision_type_code: Optional[StrictStr] = Field(default=None, description="Provision type code, eg. `amazon`, etc.", alias="provisionTypeCode")
    scripts: Optional[List[StrictInt]] = Field(default=None, description="Array of script IDs.")
    templates: Optional[List[StrictInt]] = Field(default=None, description="Array of file template IDs.")
    virtual_image_id: Optional[StrictInt] = Field(default=None, description="Virtual image ID", alias="virtualImageId")
    os_type_id: Optional[StrictInt] = Field(default=None, description="OsType ID", alias="osTypeId")
    stat_type_code: Optional[StrictStr] = Field(default=None, description="Stat type code.  Varies with node type, see Provision Types (customOptionTypes) for allowed values within selected type.", alias="statTypeCode")
    log_type_code: Optional[StrictStr] = Field(default=None, description="Log type code.  Varies with node type, see Provision Types (customOptionTypes) for allowed values within selected type.", alias="logTypeCode")
    server_type: Optional[StrictStr] = Field(default=None, description="Server type.  Always pass \"vm\".", alias="serverType")
    container_ports: Optional[List[AddNodeTypeRequestContainerTypeContainerPortsInner]] = Field(default=None, description="List of exposed port definitions in the format NAME=PORT|PROTOCOL", alias="containerPorts")
    environment_variables: Optional[List[AddClusterLayoutsRequestLayoutEnvironmentVariablesInner]] = Field(default=None, description="The environmentVariables parameter is array of env objects.", alias="environmentVariables")
    config: Optional[Dict[str, Any]] = Field(default=None, description="Config object varies with node type.  If using docker, scvmm, ARM, hyperv, or cloudformation, look up provision type details (customOptionTypes) for information.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "labels", "shortName", "description", "containerVersion", "provisionTypeCode", "scripts", "templates", "virtualImageId", "osTypeId", "statTypeCode", "logTypeCode", "serverType", "containerPorts", "environmentVariables", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContainerTypeUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in container_ports (list)
        _items = []
        if self.container_ports:
            for _item_container_ports in self.container_ports:
                if _item_container_ports:
                    _items.append(_item_container_ports.to_dict())
            _dict['containerPorts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in environment_variables (list)
        _items = []
        if self.environment_variables:
            for _item_environment_variables in self.environment_variables:
                if _item_environment_variables:
                    _items.append(_item_environment_variables.to_dict())
            _dict['environmentVariables'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContainerTypeUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "shortName": obj.get("shortName"),
            "description": obj.get("description"),
            "containerVersion": obj.get("containerVersion"),
            "provisionTypeCode": obj.get("provisionTypeCode"),
            "scripts": obj.get("scripts"),
            "templates": obj.get("templates"),
            "virtualImageId": obj.get("virtualImageId"),
            "osTypeId": obj.get("osTypeId"),
            "statTypeCode": obj.get("statTypeCode"),
            "logTypeCode": obj.get("logTypeCode"),
            "serverType": obj.get("serverType"),
            "containerPorts": [AddNodeTypeRequestContainerTypeContainerPortsInner.from_dict(_item) for _item in obj["containerPorts"]] if obj.get("containerPorts") is not None else None,
            "environmentVariables": [AddClusterLayoutsRequestLayoutEnvironmentVariablesInner.from_dict(_item) for _item in obj["environmentVariables"]] if obj.get("environmentVariables") is not None else None,
            "config": obj.get("config")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


