# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_email_templates200_response_all_of_email_templates_inner_owner import ListEmailTemplates200ResponseAllOfEmailTemplatesInnerOwner
from typing import Optional, Set
from typing_extensions import Self

class EmailTemplate(BaseModel):
    """
    EmailTemplate
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = Field(default=None, description="The name of the email template. This is set by morpheus. ")
    code: Optional[StrictStr] = Field(default=None, description="A unique code for the email template. This code is used to reference the email template and as a reference of the templates type. ")
    owner: Optional[ListEmailTemplates200ResponseAllOfEmailTemplatesInnerOwner] = None
    accounts: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    template: Optional[StrictStr] = Field(default=None, description="The email template. This is the actual email template that is sent to the user. This uses handlebars notation (not javascript) ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "owner", "accounts", "template"]

    @field_validator('code')
    def code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['instanceExpired', 'instanceShutdown', 'instanceNotifyExpiring', 'notifyShutdownWarningInstance', 'forgotPassword', 'inactiveWarning', 'warnOldPassword', 'confirmPassUpdate', 'userAccountConfirmEmail', 'confirmEmail', 'registerSuccess', 'instanceComplete', 'instanceScaleComplete']):
            raise ValueError("must be one of enum values ('instanceExpired', 'instanceShutdown', 'instanceNotifyExpiring', 'notifyShutdownWarningInstance', 'forgotPassword', 'inactiveWarning', 'warnOldPassword', 'confirmPassUpdate', 'userAccountConfirmEmail', 'confirmEmail', 'registerSuccess', 'instanceComplete', 'instanceScaleComplete')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if accounts (nullable) is None
        # and model_fields_set contains the field
        if self.accounts is None and "accounts" in self.model_fields_set:
            _dict['accounts'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "owner": ListEmailTemplates200ResponseAllOfEmailTemplatesInnerOwner.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "accounts": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["accounts"]] if obj.get("accounts") is not None else None,
            "template": obj.get("template")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


