# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_option_type_request_option_type_option_list import AddOptionTypeRequestOptionTypeOptionList
from typing import Optional, Set
from typing_extensions import Self

class FormField(BaseModel):
    """
    FormField
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The ID of the input, include this to use an existing input or to update an existing form input record instead of creating a new one.")
    code: Optional[StrictStr] = Field(default=None, description="The code of the option type as a globally unique identifier. By default a UUID will be used.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the option type for handy reference. By default a UUID will be used.")
    description: Optional[StrictStr] = Field(default=None, description="Short description of the option type")
    field_name: StrictStr = Field(description="Field Name, the name for user input. This along with fieldContext determines the configuration property name.  The property key for when posting this option type to a JSON POST request", alias="fieldName")
    type: Optional[StrictStr] = Field(default='text', description="Type, the type of input. eg. text, checkbox, select, etc.")
    field_label: StrictStr = Field(description="Field Label, the label for user input.", alias="fieldLabel")
    field_code: Optional[StrictStr] = Field(default=None, description="Localized Label, i18n code for the label", alias="fieldCode")
    place_holder: Optional[StrictStr] = Field(default=None, description="Any placeholder text when nothing is yet entered", alias="placeHolder")
    help_block: Optional[StrictStr] = Field(default=None, description="This is the explaination of the input that shows typically underneath the option", alias="helpBlock")
    help_block_field_code: Optional[StrictStr] = Field(default=None, description="Localized Help Block, i18n code for the help block", alias="helpBlockFieldCode")
    default_value: Optional[StrictStr] = Field(default=None, description="The default value if no user entry is specified. This value should be passed to the desired JSON Map if nothing else is entered", alias="defaultValue")
    required: Optional[StrictBool] = Field(default=False, description="Is this field entry required for the request")
    export_meta: Optional[StrictBool] = Field(default=False, description="Export as Tag", alias="exportMeta")
    editable: Optional[StrictBool] = Field(default=False, description="Used primarily on tasks and workflows. Basically wether or not the field can be overridden optionally when the object is run")
    option_list: Optional[AddOptionTypeRequestOptionTypeOptionList] = Field(default=None, alias="optionList")
    display_value_on_details: Optional[StrictBool] = Field(default=False, description="Display Value On Details", alias="displayValueOnDetails")
    is_locked: Optional[StrictBool] = Field(default=False, description="Locked", alias="isLocked")
    is_hidden: Optional[StrictBool] = Field(default=False, description="Hidden", alias="isHidden")
    exclude_from_search: Optional[StrictBool] = Field(default=False, description="Exclude From Search", alias="excludeFromSearch")
    depends_on_code: Optional[StrictStr] = Field(default=None, description="A fieldName that will trigger reloading this input", alias="dependsOnCode")
    visible_on_code: Optional[StrictStr] = Field(default=None, description="A fieldName that will trigger visibility of this input", alias="visibleOnCode")
    verify_pattern: Optional[StrictStr] = Field(default=None, description="Verify Pattern, A regexp string that validates the input, use (?i) to make the matcher case insensitive", alias="verifyPattern")
    require_on_code: Optional[StrictStr] = Field(default=None, description="A fieldName that will trigger required attribute of this input", alias="requireOnCode")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "code", "name", "description", "fieldName", "type", "fieldLabel", "fieldCode", "placeHolder", "helpBlock", "helpBlockFieldCode", "defaultValue", "required", "exportMeta", "editable", "optionList", "displayValueOnDetails", "isLocked", "isHidden", "excludeFromSearch", "dependsOnCode", "visibleOnCode", "verifyPattern", "requireOnCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FormField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of option_list
        if self.option_list:
            _dict['optionList'] = self.option_list.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if field_code (nullable) is None
        # and model_fields_set contains the field
        if self.field_code is None and "field_code" in self.model_fields_set:
            _dict['fieldCode'] = None

        # set to None if help_block (nullable) is None
        # and model_fields_set contains the field
        if self.help_block is None and "help_block" in self.model_fields_set:
            _dict['helpBlock'] = None

        # set to None if help_block_field_code (nullable) is None
        # and model_fields_set contains the field
        if self.help_block_field_code is None and "help_block_field_code" in self.model_fields_set:
            _dict['helpBlockFieldCode'] = None

        # set to None if depends_on_code (nullable) is None
        # and model_fields_set contains the field
        if self.depends_on_code is None and "depends_on_code" in self.model_fields_set:
            _dict['dependsOnCode'] = None

        # set to None if visible_on_code (nullable) is None
        # and model_fields_set contains the field
        if self.visible_on_code is None and "visible_on_code" in self.model_fields_set:
            _dict['visibleOnCode'] = None

        # set to None if require_on_code (nullable) is None
        # and model_fields_set contains the field
        if self.require_on_code is None and "require_on_code" in self.model_fields_set:
            _dict['requireOnCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FormField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "fieldName": obj.get("fieldName"),
            "type": obj.get("type") if obj.get("type") is not None else 'text',
            "fieldLabel": obj.get("fieldLabel"),
            "fieldCode": obj.get("fieldCode"),
            "placeHolder": obj.get("placeHolder"),
            "helpBlock": obj.get("helpBlock"),
            "helpBlockFieldCode": obj.get("helpBlockFieldCode"),
            "defaultValue": obj.get("defaultValue"),
            "required": obj.get("required") if obj.get("required") is not None else False,
            "exportMeta": obj.get("exportMeta") if obj.get("exportMeta") is not None else False,
            "editable": obj.get("editable") if obj.get("editable") is not None else False,
            "optionList": AddOptionTypeRequestOptionTypeOptionList.from_dict(obj["optionList"]) if obj.get("optionList") is not None else None,
            "displayValueOnDetails": obj.get("displayValueOnDetails") if obj.get("displayValueOnDetails") is not None else False,
            "isLocked": obj.get("isLocked") if obj.get("isLocked") is not None else False,
            "isHidden": obj.get("isHidden") if obj.get("isHidden") is not None else False,
            "excludeFromSearch": obj.get("excludeFromSearch") if obj.get("excludeFromSearch") is not None else False,
            "dependsOnCode": obj.get("dependsOnCode"),
            "visibleOnCode": obj.get("visibleOnCode"),
            "verifyPattern": obj.get("verifyPattern"),
            "requireOnCode": obj.get("requireOnCode")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


