# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from typing import Optional, Set
from typing_extensions import Self

class GetAlerts200ResponseAllOfAppsInner(BaseModel):
    """
    GetAlerts200ResponseAllOfAppsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    active: Optional[StrictBool] = None
    app: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    in_uptime: Optional[StrictBool] = Field(default=None, alias="inUptime")
    last_check_status: Optional[StrictStr] = Field(default=None, alias="lastCheckStatus")
    last_warning_date: Optional[datetime] = Field(default=None, alias="lastWarningDate")
    last_error_date: Optional[datetime] = Field(default=None, alias="lastErrorDate")
    last_success_date: Optional[datetime] = Field(default=None, alias="lastSuccessDate")
    last_run_date: Optional[datetime] = Field(default=None, alias="lastRunDate")
    last_error: Optional[StrictStr] = Field(default=None, alias="lastError")
    last_timer: Optional[StrictInt] = Field(default=None, alias="lastTimer")
    health: Optional[StrictInt] = None
    history: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    create_incident: Optional[StrictBool] = Field(default=None, alias="createIncident")
    muted: Optional[StrictBool] = None
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    availability: Optional[StrictStr] = None
    checks: Optional[List[StrictInt]] = None
    check_groups: Optional[List[StrictInt]] = Field(default=None, alias="checkGroups")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account", "active", "app", "name", "description", "inUptime", "lastCheckStatus", "lastWarningDate", "lastErrorDate", "lastSuccessDate", "lastRunDate", "lastError", "lastTimer", "health", "history", "severity", "createIncident", "muted", "createdBy", "dateCreated", "lastUpdated", "availability", "checks", "checkGroups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAlerts200ResponseAllOfAppsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if last_check_status (nullable) is None
        # and model_fields_set contains the field
        if self.last_check_status is None and "last_check_status" in self.model_fields_set:
            _dict['lastCheckStatus'] = None

        # set to None if last_warning_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_warning_date is None and "last_warning_date" in self.model_fields_set:
            _dict['lastWarningDate'] = None

        # set to None if last_error_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_error_date is None and "last_error_date" in self.model_fields_set:
            _dict['lastErrorDate'] = None

        # set to None if last_success_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_success_date is None and "last_success_date" in self.model_fields_set:
            _dict['lastSuccessDate'] = None

        # set to None if last_run_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_run_date is None and "last_run_date" in self.model_fields_set:
            _dict['lastRunDate'] = None

        # set to None if last_error (nullable) is None
        # and model_fields_set contains the field
        if self.last_error is None and "last_error" in self.model_fields_set:
            _dict['lastError'] = None

        # set to None if history (nullable) is None
        # and model_fields_set contains the field
        if self.history is None and "history" in self.model_fields_set:
            _dict['history'] = None

        # set to None if availability (nullable) is None
        # and model_fields_set contains the field
        if self.availability is None and "availability" in self.model_fields_set:
            _dict['availability'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAlerts200ResponseAllOfAppsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "active": obj.get("active"),
            "app": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "inUptime": obj.get("inUptime"),
            "lastCheckStatus": obj.get("lastCheckStatus"),
            "lastWarningDate": obj.get("lastWarningDate"),
            "lastErrorDate": obj.get("lastErrorDate"),
            "lastSuccessDate": obj.get("lastSuccessDate"),
            "lastRunDate": obj.get("lastRunDate"),
            "lastError": obj.get("lastError"),
            "lastTimer": obj.get("lastTimer"),
            "health": obj.get("health"),
            "history": obj.get("history"),
            "severity": obj.get("severity"),
            "createIncident": obj.get("createIncident"),
            "muted": obj.get("muted"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "availability": obj.get("availability"),
            "checks": obj.get("checks"),
            "checkGroups": obj.get("checkGroups")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


