# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_billing_servers_identifier200_response_all_of_billing_info_usages_inner import GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner
from typing import Optional, Set
from typing_extensions import Self

class GetBillingServersIdentifier200ResponseAllOfBillingInfo(BaseModel):
    """
    GetBillingServersIdentifier200ResponseAllOfBillingInfo
    """ # noqa: E501
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_uuid: Optional[StrictStr] = Field(default=None, alias="refUUID")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    cost: Optional[Union[StrictFloat, StrictInt]] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    num_units: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="numUnits")
    unit: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    usages: Optional[List[GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner]] = None
    num_usages: Optional[StrictInt] = Field(default=None, alias="numUsages")
    total_usages: Optional[StrictInt] = Field(default=None, alias="totalUsages")
    has_more_usages: Optional[StrictBool] = Field(default=None, alias="hasMoreUsages")
    found_pricing: Optional[StrictBool] = Field(default=None, alias="foundPricing")
    name: Optional[StrictStr] = None
    server_uuid: Optional[StrictStr] = Field(default=None, alias="serverUUID")
    server_unique_id: Optional[StrictStr] = Field(default=None, alias="serverUniqueId")
    server_external_id: Optional[StrictStr] = Field(default=None, alias="serverExternalId")
    server_internal_id: Optional[StrictStr] = Field(default=None, alias="serverInternalId")
    resource_pool_id: Optional[StrictInt] = Field(default=None, alias="resourcePoolId")
    resource_pool_name: Optional[StrictStr] = Field(default=None, alias="resourcePoolName")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["refType", "refUUID", "refId", "startDate", "endDate", "cost", "price", "numUnits", "unit", "currency", "usages", "numUsages", "totalUsages", "hasMoreUsages", "foundPricing", "name", "serverUUID", "serverUniqueId", "serverExternalId", "serverInternalId", "resourcePoolId", "resourcePoolName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetBillingServersIdentifier200ResponseAllOfBillingInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in usages (list)
        _items = []
        if self.usages:
            for _item_usages in self.usages:
                if _item_usages:
                    _items.append(_item_usages.to_dict())
            _dict['usages'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if server_unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_unique_id is None and "server_unique_id" in self.model_fields_set:
            _dict['serverUniqueId'] = None

        # set to None if server_internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_internal_id is None and "server_internal_id" in self.model_fields_set:
            _dict['serverInternalId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetBillingServersIdentifier200ResponseAllOfBillingInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "refType": obj.get("refType"),
            "refUUID": obj.get("refUUID"),
            "refId": obj.get("refId"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "cost": obj.get("cost"),
            "price": obj.get("price"),
            "numUnits": obj.get("numUnits"),
            "unit": obj.get("unit"),
            "currency": obj.get("currency"),
            "usages": [GetBillingServersIdentifier200ResponseAllOfBillingInfoUsagesInner.from_dict(_item) for _item in obj["usages"]] if obj.get("usages") is not None else None,
            "numUsages": obj.get("numUsages"),
            "totalUsages": obj.get("totalUsages"),
            "hasMoreUsages": obj.get("hasMoreUsages"),
            "foundPricing": obj.get("foundPricing"),
            "name": obj.get("name"),
            "serverUUID": obj.get("serverUUID"),
            "serverUniqueId": obj.get("serverUniqueId"),
            "serverExternalId": obj.get("serverExternalId"),
            "serverInternalId": obj.get("serverInternalId"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "resourcePoolName": obj.get("resourcePoolName")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


